/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.registries;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import net.remmintan.mods.minefortress.core.interfaces.networking.INetworkingReader;

public class NetworkingReadersRegistry {
    public static HashSet<INetworkingReader<?>> registeredReaders = new HashSet(new ConcurrentHashMap().keySet());

    public static void addReader(INetworkingReader<?> reader) {
        registeredReaders.add(reader);
    }

    public static <T> INetworkingReader<T> findReader(Class<T> typeToRead) {
        for (INetworkingReader<T> iNetworkingReader : registeredReaders) {
            if (!iNetworkingReader.canReadForType(typeToRead)) continue;
            return iNetworkingReader;
        }
        throw new RuntimeException("No reader found for type " + typeToRead.getName());
    }
}

