/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.interfaces.selections.ServerSelectionType;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IServerTaskManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;

public class ServerboundSimpleSelectionTaskPacket
implements FortressC2SPacket {
    private final UUID id;
    private final TaskType taskType;
    private final class_2338 start;
    private final class_2338 end;
    private final class_239 hitResult;
    private final String selectionType;

    public ServerboundSimpleSelectionTaskPacket(UUID id, TaskType taskType, class_2338 start, class_2338 end, class_239 hitResult, String selectionType) {
        this.id = id;
        this.taskType = taskType;
        this.start = start;
        this.end = end;
        this.hitResult = hitResult;
        this.selectionType = selectionType;
    }

    public ServerboundSimpleSelectionTaskPacket(class_2540 buffer) {
        this.id = buffer.method_10790();
        this.taskType = (TaskType)buffer.method_10818(TaskType.class);
        this.start = buffer.method_10811();
        this.end = buffer.method_10811();
        class_239.class_240 hitType = (class_239.class_240)buffer.method_10818(class_239.class_240.class);
        this.hitResult = hitType == class_239.class_240.field_1332 ? buffer.method_17814() : null;
        this.selectionType = buffer.method_19772();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10797(this.id);
        buffer.method_10817((Enum)this.taskType);
        buffer.method_10807(this.start);
        buffer.method_10807(this.end);
        class_239.class_240 type = Optional.ofNullable(this.hitResult).map(class_239::method_17783).orElse(class_239.class_240.field_1333);
        buffer.method_10817((Enum)type);
        if (type == class_239.class_240.field_1332) {
            buffer.method_17813((class_3965)this.hitResult);
        }
        buffer.method_10814(this.selectionType);
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public class_2338 getStart() {
        return this.start;
    }

    public class_2338 getEnd() {
        return this.end;
    }

    public class_239 getHitResult() {
        return this.hitResult;
    }

    public ServerSelectionType getSelectionType() {
        return ServerSelectionType.valueOf(this.selectionType);
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        IServerManagersProvider provider = this.getManagersProvider(server, player);
        UUID id = this.getId();
        TaskType taskType = this.getTaskType();
        IServerTaskManager taskManager = provider.getTaskManager();
        class_2338 startingBlock = this.getStart();
        class_2338 endingBlock = this.getEnd();
        class_239 hitResult = this.getHitResult();
        ServerSelectionType selectionType = this.getSelectionType();
        ITask task = taskManager.createSelectionTask(id, taskType, startingBlock, endingBlock, selectionType, hitResult, player);
        IServerFortressManager manager = this.getFortressManager(server, player);
        taskManager.addTask(task, provider, manager);
    }
}

