/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IServerTaskManager;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;

public class ServerboundRoadsTaskPacket
implements FortressC2SPacket {
    private final UUID digUuid;
    private final UUID placeUuid;
    private final List<class_2338> blocks;

    public ServerboundRoadsTaskPacket(UUID digUuid, UUID placeUuid, List<class_2338> blocks) {
        this.digUuid = digUuid;
        this.placeUuid = placeUuid;
        this.blocks = Collections.unmodifiableList(blocks);
    }

    public ServerboundRoadsTaskPacket(class_2540 buf) {
        this.digUuid = buf.method_10790();
        this.placeUuid = buf.method_10790();
        this.blocks = (List)buf.method_34068(ArrayList::new, class_2540::method_10811);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.digUuid);
        buf.method_10797(this.placeUuid);
        buf.method_34062(this.blocks, class_2540::method_10807);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        IServerManagersProvider provider = this.getManagersProvider(server, player);
        IServerTaskManager taskManager = provider.getTaskManager();
        IServerResourceManager resourceManager = provider.getResourceManager();
        class_1799 stackInHand = player.method_5998(class_1268.field_5808);
        class_1792 item = stackInHand.method_7909();
        ITask buildTask = taskManager.createRoadsTask(this.digUuid, TaskType.BUILD, this.placeUuid, this.blocks, item);
        IServerFortressManager manager = this.getFortressManager(server, player);
        Runnable onDigComplete = () -> taskManager.addTask(buildTask, provider, manager);
        if (manager.isSurvival()) {
            resourceManager.reserveItems(this.placeUuid, Collections.singletonList(resourceManager.createItemInfo(item, this.blocks.size())));
        }
        ITask digTask = taskManager.createRoadsTask(this.digUuid, TaskType.REMOVE, this.placeUuid, this.blocks, item, onDigComplete);
        taskManager.addTask(digTask, provider, manager);
    }
}

