/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintDataLayer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.BlueprintGroup;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IStructureBlockData;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.world.IBlueprintsWorld;
import net.remmintan.mods.minefortress.core.interfaces.entities.player.FortressServerPlayerEntity;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.interfaces.server.IFortressServer;

public class ServerboundEditBlueprintPacket
implements FortressC2SPacket {
    private final Type type;
    private final String blueprintFileName;
    private final int floorLevel;
    private final BlueprintGroup blueprintGroup;

    private ServerboundEditBlueprintPacket(String blueprintFileName, int floorLevel, Type type, BlueprintGroup blueprintGroup) {
        this.blueprintFileName = blueprintFileName;
        this.floorLevel = floorLevel;
        this.type = type;
        this.blueprintGroup = blueprintGroup;
    }

    public ServerboundEditBlueprintPacket(class_2540 buf) {
        this.blueprintFileName = buf.method_19772();
        this.floorLevel = buf.readInt();
        this.type = (Type)buf.method_10818(Type.class);
        this.blueprintGroup = (BlueprintGroup)buf.method_10818(BlueprintGroup.class);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10814(this.blueprintFileName);
        buf.writeInt(this.floorLevel);
        buf.method_10817((Enum)this.type);
        buf.method_10817((Enum)this.blueprintGroup);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (server instanceof IFortressServer) {
            IFortressServer fortressServer = (IFortressServer)server;
            if (player instanceof FortressServerPlayerEntity) {
                FortressServerPlayerEntity fortressPlayer = (FortressServerPlayerEntity)player;
                if (this.type == Type.REMOVE) {
                    fortressPlayer.get_ServerBlueprintManager().remove(this.blueprintFileName);
                } else {
                    IBlueprintsWorld blueprintsWorld = fortressServer.get_BlueprintsWorld();
                    if (this.type == Type.EDIT) {
                        IStructureBlockData blockData = fortressPlayer.get_ServerBlueprintManager().getBlockDataManager().getBlockData(this.blueprintFileName, class_2470.field_11467);
                        Map<class_2338, class_2680> blueprintData = blockData.getLayer(BlueprintDataLayer.GENERAL);
                        blueprintsWorld.prepareBlueprint(blueprintData, this.blueprintFileName, this.floorLevel, this.blueprintGroup);
                        blueprintsWorld.putBlueprintInAWorld(player, blockData.getSize());
                    } else if (this.type == Type.CREATE) {
                        blueprintsWorld.prepareBlueprint(new HashMap<class_2338, class_2680>(), this.blueprintFileName, this.floorLevel, this.blueprintGroup);
                        blueprintsWorld.putBlueprintInAWorld(player, new class_2382(1, 1, 1));
                    }
                    player.method_5731((class_3218)blueprintsWorld.getWorld());
                }
            }
        }
    }

    public static ServerboundEditBlueprintPacket edit(String name, int floorLevel, BlueprintGroup group) {
        return new ServerboundEditBlueprintPacket(name, floorLevel, Type.EDIT, group);
    }

    public static ServerboundEditBlueprintPacket add(String name, BlueprintGroup group) {
        return new ServerboundEditBlueprintPacket(name, 0, Type.CREATE, group);
    }

    public static ServerboundEditBlueprintPacket remove(String name) {
        return new ServerboundEditBlueprintPacket(name, 0, Type.REMOVE, BlueprintGroup.LIVING_HOUSES);
    }

    private static enum Type {
        EDIT,
        CREATE,
        REMOVE;

    }
}

