/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.interfaces.professions.IProfession;
import net.remmintan.mods.minefortress.core.interfaces.professions.IServerProfessionsManager;
import net.remmintan.mods.minefortress.core.interfaces.professions.ProfessionsHireTypes;

public class ServerboundChangeProfessionStatePacket
implements FortressC2SPacket {
    private final String professionId;
    private final AmountChange amountChange;

    public ServerboundChangeProfessionStatePacket(String professionId, AmountChange amountChange) {
        this.professionId = professionId;
        this.amountChange = amountChange;
    }

    public ServerboundChangeProfessionStatePacket(class_2540 buf) {
        this.professionId = buf.method_19772();
        this.amountChange = AmountChange.values()[buf.readInt()];
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10814(this.professionId);
        buf.writeInt(this.amountChange.ordinal());
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        IServerProfessionsManager manager = this.getManagersProvider(server, player).getProfessionsManager();
        if (this.amountChange == AmountChange.ADD) {
            IProfession profession = manager.getProfession(this.professionId);
            if (profession.isHireMenu()) {
                ProfessionsHireTypes professionsHireType = ProfessionsHireTypes.getHireType(this.professionId).orElseThrow(() -> new RuntimeException("Hire type not found for profession: " + this.professionId));
                manager.openHireMenu(professionsHireType, player);
            } else {
                manager.increaseAmount(this.professionId, false);
            }
        } else {
            manager.decreaseAmount(this.professionId);
        }
    }

    public static enum AmountChange {
        ADD,
        REMOVE;

    }
}

