/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.player.FortressServerPlayerEntity;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.utils.ModPathUtils;
import net.remmintan.mods.minefortress.networking.NetworkActionType;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.helpers.NetworkUtils;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundBlueprintsProcessImportExportPacket;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ServerboundBlueprintsImportExportPacket
implements FortressC2SPacket {
    private final NetworkActionType type;
    private final String path;
    private final byte[] bytes;

    public ServerboundBlueprintsImportExportPacket(String path) {
        this.type = NetworkActionType.EXPORT;
        this.path = path;
        this.bytes = new byte[0];
    }

    public ServerboundBlueprintsImportExportPacket(byte[] bytes) {
        this.type = NetworkActionType.IMPORT;
        this.path = "";
        this.bytes = bytes;
    }

    public ServerboundBlueprintsImportExportPacket(class_2540 buf) {
        this.type = (NetworkActionType)buf.method_10818(NetworkActionType.class);
        this.path = buf.method_19772();
        this.bytes = NetworkUtils.getDecompressedBytes(buf.method_10795());
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.type);
        buf.method_10814(this.path);
        buf.method_10813(NetworkUtils.getCompressedBytes(this.bytes));
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        if (player instanceof FortressServerPlayerEntity) {
            FortressServerPlayerEntity serverPlayer = (FortressServerPlayerEntity)player;
            switch (this.type) {
                case EXPORT: {
                    this.handleExport(server, player, serverPlayer);
                    break;
                }
                case IMPORT: {
                    this.handleImport(server, player, serverPlayer);
                }
            }
        }
    }

    private void handleExport(MinecraftServer server, class_3222 player, FortressServerPlayerEntity serverPlayer) {
        byte[] bytes;
        try {
            IServerBlueprintManager sbm = serverPlayer.get_ServerBlueprintManager();
            sbm.write();
            String blueprintsFolderPath = sbm.getBlockDataManager().getBlueprintsFolder();
            String blueprintsPath = ModPathUtils.getFolderAbsolutePath(blueprintsFolderPath, server.field_23784);
            bytes = this.zipBlueprintsFolderToByteArray(blueprintsPath);
        }
        catch (IOException | RuntimeException exp) {
            exp.printStackTrace();
            ClientboundBlueprintsProcessImportExportPacket packet = new ClientboundBlueprintsProcessImportExportPacket(ClientboundBlueprintsProcessImportExportPacket.CurrentScreenAction.FAILURE);
            FortressServerNetworkHelper.send(player, "fortress_blueprints_process_import_export", packet);
            return;
        }
        ClientboundBlueprintsProcessImportExportPacket packet = new ClientboundBlueprintsProcessImportExportPacket(this.path, bytes);
        FortressServerNetworkHelper.send(player, "fortress_blueprints_process_import_export", packet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleImport(MinecraftServer server, class_3222 player, FortressServerPlayerEntity serverPlayer) {
        try {
            IServerBlueprintManager sbm = serverPlayer.get_ServerBlueprintManager();
            String blueprintsFolderPath = sbm.getBlockDataManager().getBlueprintsFolder();
            String pathString = ModPathUtils.getFolderAbsolutePath(blueprintsFolderPath, server.field_23784);
            Path path = Paths.get(pathString, new String[0]);
            File target = path.toFile();
            FileUtils.deleteDirectory((File)target);
            target.mkdirs();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
                 ZipInputStream zis = new ZipInputStream(bais);){
                ZipEntry nextEntry;
                while ((nextEntry = zis.getNextEntry()) != null) {
                    File file = new File(target, nextEntry.getName());
                    if (!file.toPath().normalize().startsWith(target.toPath())) continue;
                    if (nextEntry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                    try {
                        IOUtils.copy((InputStream)zis, (OutputStream)fos);
                    }
                    finally {
                        if (fos == null) continue;
                        fos.close();
                    }
                }
            }
            sbm.read();
            ClientboundBlueprintsProcessImportExportPacket packet = new ClientboundBlueprintsProcessImportExportPacket(ClientboundBlueprintsProcessImportExportPacket.CurrentScreenAction.SUCCESS);
            FortressServerNetworkHelper.send(player, "fortress_blueprints_process_import_export", packet);
            return;
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            ClientboundBlueprintsProcessImportExportPacket packet = new ClientboundBlueprintsProcessImportExportPacket(ClientboundBlueprintsProcessImportExportPacket.CurrentScreenAction.FAILURE);
            FortressServerNetworkHelper.send(player, "fortress_blueprints_process_import_export", packet);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] zipBlueprintsFolderToByteArray(String pathStr) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

