/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.networking.c2s;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.remmintan.mods.minefortress.core.interfaces.blueprints.IServerBlueprintManager;
import net.remmintan.mods.minefortress.core.interfaces.entities.player.FortressServerPlayerEntity;
import net.remmintan.mods.minefortress.core.interfaces.networking.FortressC2SPacket;
import net.remmintan.mods.minefortress.core.interfaces.resources.IItemInfo;
import net.remmintan.mods.minefortress.core.interfaces.resources.IServerResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.server.IServerManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITask;
import net.remmintan.mods.minefortress.networking.helpers.FortressServerNetworkHelper;
import net.remmintan.mods.minefortress.networking.s2c.ClientboundTaskExecutedPacket;
import org.apache.logging.log4j.LogManager;

public class ServerboundBlueprintTaskPacket
implements FortressC2SPacket {
    private final UUID taskId;
    private final String blueprintId;
    private final class_2338 startPos;
    private final class_2470 rotation;
    private final int floorLevel;

    public ServerboundBlueprintTaskPacket(UUID taskId, String blueprintId, class_2338 startPos, class_2470 rotation, int floorLevel) {
        this.taskId = taskId;
        this.blueprintId = blueprintId;
        this.startPos = startPos;
        this.rotation = rotation;
        this.floorLevel = floorLevel;
    }

    public ServerboundBlueprintTaskPacket(class_2540 buf) {
        this.taskId = buf.method_10790();
        this.blueprintId = buf.method_19772();
        this.startPos = buf.method_10811();
        this.rotation = (class_2470)buf.method_10818(class_2470.class);
        this.floorLevel = buf.readInt();
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10797(this.taskId);
        buf.method_10814(this.blueprintId);
        buf.method_10807(this.startPos);
        buf.method_10817((Enum)this.rotation);
        buf.writeInt(this.floorLevel);
    }

    @Override
    public void handle(MinecraftServer server, class_3222 player) {
        if (player instanceof FortressServerPlayerEntity) {
            FortressServerPlayerEntity fortressServerPlayer = (FortressServerPlayerEntity)player;
            IServerFortressManager manager = this.getFortressManager(server, player);
            IServerBlueprintManager blueprintManager = fortressServerPlayer.get_ServerBlueprintManager();
            ITask task = blueprintManager.createTask(this.taskId, this.blueprintId, this.startPos, this.rotation, this.floorLevel);
            IServerManagersProvider provider = this.getManagersProvider(server, player);
            if (manager.isSurvival()) {
                IServerResourceManager serverResourceManager = provider.getResourceManager();
                List<IItemInfo> stacks = blueprintManager.getBlockDataManager().getBlockData(this.blueprintId, this.rotation).getStacks();
                try {
                    serverResourceManager.reserveItems(this.taskId, stacks);
                }
                catch (IllegalStateException e) {
                    LogManager.getLogger().error("Failed to reserve items for task " + this.taskId + ": " + e.getMessage());
                    FortressServerNetworkHelper.send(player, "finish_task", new ClientboundTaskExecutedPacket(this.taskId));
                    return;
                }
            }
            Runnable executeBuildTask = () -> provider.getTaskManager().addTask(task, provider, manager);
            if (this.floorLevel > 0) {
                ITask digTask = blueprintManager.createDigTask(this.taskId, this.startPos, this.floorLevel, this.blueprintId, this.rotation);
                digTask.addFinishListener(executeBuildTask);
                provider.getTaskManager().addTask(digTask, provider, manager);
            } else {
                executeBuildTask.run();
            }
        }
    }
}

