/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.core.utils;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;

public class PathUtils {
    public static List<class_2338> getLadderSelection(class_2338 selectionStart, class_2338 selectionEnd, class_2350.class_2351 axis) {
        return PathUtils.getLadderSelection(selectionStart, selectionStart, selectionEnd, axis);
    }

    public static List<class_2338> getLadderSelection(class_2338 globalStart, class_2338 selectionStart, class_2338 selectionEnd, class_2350.class_2351 axis) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)selectionStart, (class_2338)selectionEnd)) {
            int deltaAxis = PathUtils.findDeltaForAxis(globalStart, pos, axis);
            int deltaY = PathUtils.findDeltaForAxis(globalStart, pos, class_2350.class_2351.field_11052);
            if (deltaY > deltaAxis) continue;
            blocks.add(pos.method_10062());
        }
        return blocks;
    }

    public static int findDeltaForAxis(class_2338 selectionStart, class_2338 selectionEnd, class_2350.class_2351 axis) {
        int start = selectionStart.method_30558(axis);
        int end = selectionEnd.method_30558(axis);
        return Math.abs(end - start);
    }

    public static Iterable<class_2338> fromStartToEnd(final class_2338 start, class_2338 end, final boolean skipEverySecond) {
        final class_2382 moveDirection = PathUtils.getDirection(start, end);
        class_2382 diff = PathUtils.diff(start, end).method_35853(moveDirection);
        final class_2382 dimensions = new class_2382(Math.abs(diff.method_10263()), Math.abs(diff.method_10264()), Math.abs(diff.method_10260()));
        final int totalBlocks = dimensions.method_10263() * dimensions.method_10264() * dimensions.method_10260();
        return () -> new AbstractIterator<class_2338>(){
            private final class_2338.class_2339 cursor = new class_2338.class_2339();
            private int index;

            protected class_2338 computeNext() {
                if (this.index >= totalBlocks) {
                    return (class_2338)super.endOfData();
                }
                int dx = this.index % dimensions.method_10263();
                int dy = this.index / dimensions.method_10263() / dimensions.method_10260();
                int dz = this.index / dimensions.method_10263() % dimensions.method_10260();
                class_2382 offset = new class_2382(dx * moveDirection.method_10263(), dy * moveDirection.method_10264(), dz * moveDirection.method_10260());
                ++this.index;
                if (skipEverySecond) {
                    ++this.index;
                }
                return this.cursor.method_10101((class_2382)start.method_10081(offset));
            }
        };
    }

    public static class_2382 getDirection(class_2338 start, class_2338 end) {
        class_2382 diff = PathUtils.diff(start, end);
        return new class_2382(PathUtils.sign(diff.method_10263()), PathUtils.sign(diff.method_10264()), PathUtils.sign(diff.method_10260()));
    }

    private static class_2382 diff(class_2338 start, class_2338 end) {
        return end.method_10059((class_2382)start);
    }

    private static int sign(int i) {
        int nullableSign = class_3532.method_17822((double)i);
        return nullableSign == 0 ? 1 : nullableSign;
    }
}

