/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.core.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_32;

public class ModPathUtils {
    private static final Object key = new Object();
    private static volatile ModPathUtils instance;
    public static final String MOD_DIR = "minefortress";
    private static final String WORLD_DIR_PREFIX = "blueprints-customization-world";
    private final class_32 fortressLevelStorage = class_32.method_26999((Path)ModPathUtils.getModDir());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModPathUtils getInstance() {
        if (instance == null) {
            Object object = key;
            synchronized (object) {
                if (instance == null) {
                    instance = new ModPathUtils();
                }
            }
        }
        return instance;
    }

    private ModPathUtils() {
    }

    public class_32.class_5143 getBlueprintsWorldSession() {
        try {
            return this.fortressLevelStorage.method_27002(WORLD_DIR_PREFIX);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean exists(String folderName, class_32.class_5143 session) {
        return Files.exists(ModPathUtils.getWorldSaveDir(session).resolve(folderName), new LinkOption[0]);
    }

    public static List<class_2487> readAllTags(String folderName, class_32.class_5143 session, Collection<String> excludedFiles) {
        File[] files = Optional.ofNullable(ModPathUtils.getWorldSaveDir(session).resolve(folderName).toFile().listFiles()).orElse(new File[0]);
        return Arrays.stream(files).filter(it -> !it.isDirectory() && it.getAbsolutePath().endsWith(".nbt") && !excludedFiles.contains(it.getName())).map(ModPathUtils::readNbt).toList();
    }

    public static void clearFolder(String folderName, class_32.class_5143 session) {
        File folder = ModPathUtils.getWorldSaveDir(session).resolve(folderName).toFile();
        if (folder.exists()) {
            File[] files;
            for (File file : files = Optional.ofNullable(folder.listFiles()).orElse(new File[0])) {
                file.delete();
            }
        }
    }

    public static void createFolder(String folderName, class_32.class_5143 session) {
        File folder = ModPathUtils.getWorldSaveDir(session).resolve(folderName).toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static void writeAllTags(Map<String, class_2487> tags, class_32.class_5143 session) {
        tags.forEach((k, v) -> ModPathUtils.saveNbt(v, k, session));
    }

    public static void saveNbt(class_2487 nbt, String fileName, class_32.class_5143 session) {
        File file = ModPathUtils.getWorldSaveDir(session).resolve(fileName).toFile();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            class_2507.method_30614((class_2487)nbt, (File)file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_2487 readNbt(String fileName, class_32.class_5143 session) {
        File file = ModPathUtils.getWorldSaveDir(session).resolve(fileName).toFile();
        return ModPathUtils.readNbt(file);
    }

    private static class_2487 readNbt(File file) {
        if (file.exists()) {
            try {
                return class_2507.method_30613((File)file);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new class_2487();
    }

    public static String getFolderAbsolutePath(String folder, class_32.class_5143 session) {
        return ModPathUtils.getWorldSaveDir(session).resolve(folder).toAbsolutePath().toString();
    }

    private static Path getWorldSaveDir(class_32.class_5143 session) {
        Path worldDirectory = session.method_27424(class_1937.field_25179);
        Path modDirectory = worldDirectory.resolve(MOD_DIR);
        if (!modDirectory.toFile().exists()) {
            modDirectory.toFile().mkdir();
        }
        return modDirectory;
    }

    private static Path getModDir() {
        return FabricLoader.getInstance().getGameDir().resolve(MOD_DIR);
    }
}

