/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.core.interfaces.professions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public enum ProfessionsHireTypes {
    WARRIORS("Hire warriors", Set.of("warrior1", "warrior2", "archer1", "archer2")),
    MINERS("Hire miners", Set.of("miner1", "miner2", "miner3")),
    LUMBERJACKS("Hire lumberjacks", Set.of("lumberjack1", "lumberjack2", "lumberjack3"));

    private final Set<String> ids;
    private final String screenName;

    private ProfessionsHireTypes(String screenName, Set<String> ids) {
        this.screenName = screenName;
        this.ids = Collections.unmodifiableSet(ids);
    }

    private boolean contains(String id) {
        return this.ids.contains(id);
    }

    public List<String> getIds() {
        return List.copyOf(this.ids);
    }

    public String getScreenName() {
        return this.screenName;
    }

    public static Optional<ProfessionsHireTypes> getHireType(String id) {
        for (ProfessionsHireTypes type : ProfessionsHireTypes.values()) {
            if (!type.contains(id)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

