/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.mods.minefortress.core.dtos.professions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_7923;

public record ProfessionFullInfo(String key, String title, class_1792 icon, String description, String unlockMessage, String unlockMoreMessage, boolean hireMenu, Requirements requirements) {
    public void write(class_2540 packet) {
        packet.method_10814(this.key);
        packet.method_10814(this.title);
        packet.method_10793(new class_1799((class_1935)this.icon));
        packet.method_10814(this.description);
        packet.method_10814(this.unlockMessage);
        packet.method_10814(this.unlockMoreMessage);
        packet.writeBoolean(this.hireMenu);
        if (this.requirements != null) {
            packet.method_10814(this.requirements.building());
            BlockRequirement blockRequirement = this.requirements.block();
            if (blockRequirement != null) {
                packet.method_10812(class_7923.field_41175.method_10221((Object)blockRequirement.block()));
                packet.writeBoolean(blockRequirement.inBlueprint());
            } else {
                packet.method_10812(class_7923.field_41175.method_10221((Object)class_2246.field_10124));
                packet.writeBoolean(false);
            }
            packet.method_10804(this.requirements.items().size());
            for (ItemRequirement itemReq : this.requirements.items()) {
                packet.method_10793(itemReq.toStack());
            }
        } else {
            packet.method_10814("");
            packet.method_10812(class_7923.field_41175.method_10221((Object)class_2246.field_10124));
            packet.writeBoolean(false);
            packet.method_10804(0);
        }
    }

    public static ProfessionFullInfo read(class_2540 packet) {
        String key = packet.method_19772();
        String title = packet.method_19772();
        class_1792 icon = packet.method_10819().method_7909();
        String description = packet.method_19772();
        String unlockMessage = packet.method_19772();
        String unlockMoreMessage = packet.method_19772();
        boolean cantRemove = packet.readBoolean();
        String building = packet.method_19772();
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(packet.method_10810());
        boolean inBlueprint = packet.readBoolean();
        List<ItemRequirement> items = packet.method_34066(class_2540::method_10819).stream().map(ItemRequirement::fromStack).toList();
        Requirements requirements = new Requirements(building, new BlockRequirement(block, inBlueprint), items);
        return new ProfessionFullInfo(key, title, icon, description, unlockMessage, unlockMoreMessage, cantRemove, requirements);
    }

    public record Requirements(String building, BlockRequirement block, List<ItemRequirement> items) {
        private final String building;
        private final List<ItemRequirement> items;

        public String building() {
            return Optional.ofNullable(this.building).orElse("_");
        }

        public List<ItemRequirement> items() {
            return Optional.ofNullable(this.items).orElse(Collections.emptyList());
        }
    }

    public record BlockRequirement(class_2248 block, boolean inBlueprint) {
        private final class_2248 block;

        public class_2248 block() {
            return Optional.ofNullable(this.block).orElse(class_2246.field_10124);
        }
    }

    public record ItemRequirement(class_1792 item, int count) {
        private class_1799 toStack() {
            return new class_1799((class_1935)this.item, this.count);
        }

        private static ItemRequirement fromStack(class_1799 stack) {
            return new ItemRequirement(stack.method_7909(), stack.method_7947());
        }
    }
}

