/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.remmintan.gobi.helpers.TreeBlocks;

public class TreeHelper {
    public static Optional<TreeInfo> checkIfTree(class_2338 treeRoot, class_1937 world) {
        int logCount = 0;
        int leavesCount = 0;
        class_2338 highestLeaf = class_2338.field_10980;
        for (int i = 0; i < 32; ++i) {
            class_2338 layerStart = new class_2338(treeRoot.method_10263() - 2, treeRoot.method_10264() + i, treeRoot.method_10260() - 2);
            class_2338 layerEnd = new class_2338(treeRoot.method_10263() + 2, treeRoot.method_10264() + i, treeRoot.method_10260() + 2);
            boolean layerIsEmpty = true;
            for (class_2338 pos : class_2338.method_10097((class_2338)layerStart, (class_2338)layerEnd)) {
                class_2680 blockState = world.method_8320(pos);
                if (TreeHelper.isLog(blockState)) {
                    ++logCount;
                    layerIsEmpty = false;
                }
                if (!TreeHelper.isLeaves(blockState)) continue;
                ++leavesCount;
                layerIsEmpty = false;
                if (pos.method_10264() <= highestLeaf.method_10264()) continue;
                highestLeaf = pos.method_10062();
            }
            if (layerIsEmpty) break;
        }
        if (logCount == 0 || leavesCount < 9) {
            return Optional.empty();
        }
        return Optional.of(new TreeInfo(logCount, highestLeaf));
    }

    public static boolean isLog(class_2680 blockState) {
        return blockState.method_26164(class_3481.field_15475);
    }

    public static boolean isLeaves(class_2680 blockState) {
        return blockState.method_26164(class_3481.field_15503) || blockState.method_26204() instanceof class_2397;
    }

    public static Optional<TreeBlocks> getTreeBlocks(class_2338 root, class_1937 world) {
        Optional<TreeInfo> treeInfoOpt = TreeHelper.checkIfTree(root, world);
        if (treeInfoOpt.isPresent()) {
            class_2680 rootBlockState = world.method_8320(root);
            ArrayList<class_2338> treeBlocks = new ArrayList<class_2338>();
            ArrayList<class_2338> leavesBlocks = new ArrayList<class_2338>();
            TreeHelper.updateTreeDataForOneTree(world, treeBlocks, leavesBlocks, root, rootBlockState, root);
            return Optional.of(new TreeBlocks(treeBlocks, leavesBlocks));
        }
        return Optional.empty();
    }

    private static void updateTreeDataForOneTree(class_1937 world, List<class_2338> treeBlocks, List<class_2338> leavesBlocks, class_2338 cursor, class_2680 rootBlockState, class_2338 root) {
        if (!TreeHelper.isLog(rootBlockState)) {
            return;
        }
        class_2338 areaStart = new class_2338(cursor.method_10263() - 1, cursor.method_10264(), cursor.method_10260() - 1);
        class_2338 areaEnd = new class_2338(cursor.method_10263() + 1, cursor.method_10264() + 1, cursor.method_10260() + 1);
        ArrayList<class_2338> neighbors = new ArrayList<class_2338>();
        for (class_2338 pos : class_2338.method_10097((class_2338)areaStart, (class_2338)areaEnd)) {
            double distanceToRoot;
            if (treeBlocks.contains(pos = pos.method_10062()) || leavesBlocks.contains(pos)) continue;
            class_2680 blockState = world.method_8320(pos);
            if (rootBlockState.equals(blockState)) {
                treeBlocks.add(pos);
                neighbors.add(pos);
                continue;
            }
            if (!TreeHelper.isLeaves(blockState) || !((distanceToRoot = Math.sqrt(Math.pow(pos.method_10263() - root.method_10263(), 2.0) + Math.pow(pos.method_10260() - root.method_10260(), 2.0))) <= 3.0)) continue;
            leavesBlocks.add(pos);
            neighbors.add(pos);
        }
        for (class_2338 neighbor : neighbors) {
            TreeHelper.updateTreeDataForOneTree(world, treeBlocks, leavesBlocks, neighbor, rootBlockState, root);
        }
    }

    record TreeInfo(int logsCount, class_2338 highestLeaf) {
    }
}

