/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_634;
import net.remmintan.gobi.Selection;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundSimpleSelectionTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;

public class WallsSelection
extends Selection {
    protected final List<class_2338> corners = new ArrayList<class_2338>();
    private ClickType clickType;
    protected int upDelta;
    protected List<class_2338> selection;
    private List<Pair<class_2382, class_2382>> selectionSizes;

    @Override
    public boolean isSelecting() {
        return !this.corners.isEmpty();
    }

    @Override
    public boolean needUpdate(class_2338 pickedBlock, int upDelta) {
        if (this.corners.isEmpty()) {
            return false;
        }
        if (this.upDelta != upDelta) {
            return true;
        }
        class_2338 last = this.getLastCorner();
        if (this.corners.size() == 1) {
            return true;
        }
        return !last.equals((Object)pickedBlock);
    }

    @Override
    public void update(class_2338 pickedBlock, int upDelta) {
        if (pickedBlock == null) {
            return;
        }
        pickedBlock = pickedBlock.method_10062();
        this.upDelta = upDelta;
        this.updateCorners(pickedBlock);
        ArrayList<Pair<class_2338, class_2338>> cornerPairs = this.getCornerPairs();
        this.selection = this.getSelection(upDelta, cornerPairs);
        this.selectionSizes = this.getSelectionDimensions(upDelta, cornerPairs);
    }

    protected List<Pair<class_2382, class_2382>> getSelectionDimensions(int upDelta, ArrayList<Pair<class_2338, class_2338>> cornerPairs) {
        return cornerPairs.stream().map(p -> Selection.getSelectionDimensions((class_2338)p.getFirst(), ((class_2338)p.getSecond()).method_10086(upDelta))).toList();
    }

    protected List<class_2338> getSelection(int upDelta, ArrayList<Pair<class_2338, class_2338>> cornerPairs) {
        return cornerPairs.stream().map(p -> {
            class_2338 start = (class_2338)p.getFirst();
            class_2338 end = (class_2338)p.getSecond();
            return class_2338.method_10097((class_2338)start, (class_2338)new class_2338(end.method_10263(), start.method_10264() + upDelta, end.method_10260()));
        }).flatMap(WallsSelection::iterableToList).toList();
    }

    private ArrayList<Pair<class_2338, class_2338>> getCornerPairs() {
        ArrayList<Pair<class_2338, class_2338>> cornerPairs = new ArrayList<Pair<class_2338, class_2338>>();
        if (this.corners.size() == 1) {
            cornerPairs.add((Pair<class_2338, class_2338>)Pair.of((Object)this.corners.get(0), (Object)this.corners.get(0)));
        } else {
            for (int i = 0; i < this.corners.size() - 1; ++i) {
                class_2338 thisCorner = this.corners.get(i);
                class_2338 nextCorner = this.corners.get(i + 1);
                Pair pair = Pair.of((Object)thisCorner, (Object)nextCorner);
                cornerPairs.add((Pair<class_2338, class_2338>)pair);
            }
        }
        return cornerPairs;
    }

    public static Stream<class_2338> iterableToList(Iterable<class_2338> iterable) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (class_2338 pos : iterable) {
            positions.add(pos.method_10062());
        }
        return positions.stream();
    }

    private void updateCorners(class_2338 pickedBlock) {
        class_2338 last = this.getLastCorner();
        if (this.corners.size() == 1) {
            if (!this.corners.get(0).equals((Object)pickedBlock)) {
                class_2338 subtract = pickedBlock.method_10059((class_2382)last);
                if (subtract.method_10263() == 0 || subtract.method_10260() == 0) {
                    this.corners.add(pickedBlock);
                } else if (Math.abs(subtract.method_10263()) < Math.abs(subtract.method_10260())) {
                    class_2338 newPicked = new class_2338(last.method_10263(), pickedBlock.method_10264(), pickedBlock.method_10260());
                    this.corners.add(newPicked);
                } else {
                    class_2338 newPicked = new class_2338(pickedBlock.method_10263(), pickedBlock.method_10264(), last.method_10260());
                    this.corners.add(newPicked);
                }
            }
            return;
        }
        class_2338 preLastCorner = this.getPreLastCorner();
        if (preLastCorner.equals((Object)pickedBlock) || WallsSelection.flatCloserThan((class_2382)preLastCorner, (class_2382)pickedBlock)) {
            this.corners.remove(this.corners.size() - 1);
            return;
        }
        if (this.blockOnOneLineWithLastTwo(pickedBlock)) {
            this.setLast(pickedBlock);
        } else {
            class_2338 newLast;
            LastTwoBlocksLine lastTwoBlocksLine = this.getLastTwoBlocksLine();
            if (lastTwoBlocksLine == LastTwoBlocksLine.X) {
                newLast = new class_2338(last.method_10263(), last.method_10264(), pickedBlock.method_10260());
            } else if (lastTwoBlocksLine == LastTwoBlocksLine.Z) {
                newLast = new class_2338(pickedBlock.method_10263(), last.method_10264(), last.method_10260());
            } else {
                throw new IllegalStateException("Two blocks are not on one line");
            }
            this.setLast(newLast);
            if (WallsSelection.flatCloserThan((class_2382)newLast, (class_2382)pickedBlock)) {
                return;
            }
            this.corners.add(pickedBlock);
        }
    }

    private static boolean flatCloserThan(class_2382 it, class_2382 other) {
        int d2;
        int d1 = it.method_10263() - other.method_10263();
        return (double)(d1 * d1 + (d2 = it.method_10260() - other.method_10260()) * d2) < 6.25;
    }

    private void setLast(class_2338 pickedBlock) {
        this.corners.set(this.corners.size() - 1, pickedBlock);
    }

    @Override
    public boolean selectBlock(class_1937 level, class_1792 mainHandItem, class_2338 pickedBlock, int upDelta, ClickType click, class_634 connection, class_239 hitResult) {
        if (this.corners.isEmpty()) {
            this.corners.add(pickedBlock.method_10062());
            this.clickType = click;
            return false;
        }
        if (this.clickType == click) {
            UUID supertaskUuid = UUID.randomUUID();
            TaskType taskType = WallsSelection.mapClickTypeToTaskType(this.clickType);
            this.getCornerPairs().forEach((Consumer<Pair<class_2338, class_2338>>)((Consumer<Pair>)p -> {
                UUID uuid = UUID.randomUUID();
                if (level instanceof ITasksInformationHolder) {
                    ITasksInformationHolder holder = (ITasksInformationHolder)level;
                    holder.get_ClientTasksHolder().addTask(uuid, this.getSelection(), taskType, supertaskUuid);
                }
                ServerboundSimpleSelectionTaskPacket packet = new ServerboundSimpleSelectionTaskPacket(uuid, taskType, (class_2338)p.getFirst(), ((class_2338)p.getSecond()).method_10086(upDelta), hitResult, this.getSelectionType().name());
                FortressClientNetworkHelper.send("new_task", packet);
            }));
        }
        return true;
    }

    protected ISelectionType getSelectionType() {
        return SelectionType.WALLS;
    }

    private boolean blockOnOneLineWithLastTwo(class_2338 pos) {
        class_2338 lastCorner = this.getLastCorner();
        LastTwoBlocksLine lastTwoBlocksLine = this.getLastTwoBlocksLine();
        if (lastTwoBlocksLine == LastTwoBlocksLine.Z) {
            return lastCorner.method_10260() == pos.method_10260();
        }
        if (lastTwoBlocksLine == LastTwoBlocksLine.X) {
            return lastCorner.method_10263() == pos.method_10263();
        }
        throw new IllegalStateException("Last two blocks are not on one line");
    }

    private LastTwoBlocksLine getLastTwoBlocksLine() {
        boolean lastTwoBlocksOnOneLineByZ;
        class_2338 lastCorner = this.getLastCorner();
        class_2338 preLastCorner = this.getPreLastCorner();
        boolean lastTwoBlocksOnOneLineByX = lastCorner.method_10263() == preLastCorner.method_10263();
        boolean bl = lastTwoBlocksOnOneLineByZ = lastCorner.method_10260() == preLastCorner.method_10260();
        if (lastTwoBlocksOnOneLineByZ) {
            return LastTwoBlocksLine.Z;
        }
        if (lastTwoBlocksOnOneLineByX) {
            return LastTwoBlocksLine.X;
        }
        throw new IllegalStateException("Last two blocks are not on one line");
    }

    private class_2338 getPreLastCorner() {
        return this.corners.get(this.corners.size() - 2);
    }

    private class_2338 getLastCorner() {
        return this.corners.get(this.corners.size() - 1);
    }

    @Override
    public List<class_2338> getSelection() {
        return this.selection != null ? this.selection : Collections.emptyList();
    }

    @Override
    public void reset() {
        this.corners.clear();
        this.clickType = null;
        this.upDelta = 0;
        this.selection = null;
        this.selectionSizes = null;
    }

    @Override
    public List<Pair<class_2382, class_2382>> getSelectionDimensions() {
        return this.selectionSizes != null ? this.selectionSizes : Collections.emptyList();
    }

    @Override
    public List<Pair<class_243, String>> getSelectionLabelsPosition() {
        if (this.corners.isEmpty()) {
            return super.getSelectionLabelsPosition();
        }
        ArrayList<Pair<class_243, String>> labels = new ArrayList<Pair<class_243, String>>();
        for (int i = 0; i < this.corners.size() - 1; ++i) {
            class_2338 first = this.corners.get(i);
            class_2338 second = this.corners.get(i + 1);
            List<Pair<class_243, String>> selectionLabels = WallsSelection.getSelectionLabels(first, second.method_10086(this.upDelta), i == 0);
            labels.addAll(selectionLabels);
        }
        return labels;
    }

    static enum LastTwoBlocksLine {
        X,
        Z;

    }
}

