/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.remmintan.gobi.Selection;
import net.remmintan.gobi.SelectionType;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundSimpleSelectionTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;

public class TwoDotsSelection
extends Selection {
    protected class_2338 selectionStart;
    private class_2338 selectionEnd;
    private List<class_2338> selection;
    private ClickType clickType;

    @Override
    public boolean isSelecting() {
        return this.selectionStart != null;
    }

    @Override
    public boolean needUpdate(class_2338 pickedBlock, int upSelectionDelta) {
        if (pickedBlock == null) {
            return false;
        }
        pickedBlock = pickedBlock.method_10086(upSelectionDelta);
        return this.selectionStart != null && !pickedBlock.equals((Object)this.selectionEnd);
    }

    @Override
    public boolean selectBlock(class_1937 level, class_1792 item, class_2338 pickedBlock, int upSelectionDelta, ClickType click, class_634 connection, class_239 hitResult) {
        if (this.selectionStart == null) {
            this.selectionStart = pickedBlock;
            this.clickType = click;
            return false;
        }
        if (pickedBlock != null && hitResult instanceof class_3965 && click == this.clickType && connection != null && this.selectionEnd != null) {
            UUID newTaskId = UUID.randomUUID();
            TaskType taskType = TwoDotsSelection.mapClickTypeToTaskType(this.clickType);
            if (level instanceof ITasksInformationHolder) {
                ITasksInformationHolder holder = (ITasksInformationHolder)level;
                holder.get_ClientTasksHolder().addTask(newTaskId, this.getSelection(), taskType);
            }
            ServerboundSimpleSelectionTaskPacket packet = new ServerboundSimpleSelectionTaskPacket(newTaskId, taskType, this.selectionStart, this.selectionEnd, hitResult, this.getSelectionType().name());
            FortressClientNetworkHelper.send("new_task", packet);
        }
        return true;
    }

    protected ISelectionType getSelectionType() {
        return SelectionType.SQUARES;
    }

    @Override
    public void update(class_2338 pickedBlock, int upDelta) {
        this.selectionEnd = pickedBlock.method_10086(upDelta);
        this.selection = this.getIterableForSelectionUpdate(this.selectionStart, this.selectionEnd);
    }

    protected List<class_2338> getIterableForSelectionUpdate(class_2338 selectionStart, class_2338 selectionEnd) {
        return StreamSupport.stream(class_2338.method_10097((class_2338)selectionStart, (class_2338)selectionEnd).spliterator(), false).map(class_2338::method_10062).collect(Collectors.toList());
    }

    @Override
    public List<class_2338> getSelection() {
        return this.selection != null ? this.selection : Collections.emptyList();
    }

    @Override
    public void reset() {
        this.selectionStart = null;
        this.selectionEnd = null;
        this.clickType = null;
        this.selection = null;
    }

    @Override
    public List<Pair<class_2382, class_2382>> getSelectionDimensions() {
        Pair<class_2382, class_2382> size = TwoDotsSelection.getSelectionDimensions(this.selectionStart, this.selectionEnd);
        return Collections.singletonList(size);
    }

    @Override
    public List<Pair<class_243, String>> getSelectionLabelsPosition() {
        class_2338 selectionEnd = this.selectionEnd;
        class_2338 selectionStart = this.selectionStart;
        return TwoDotsSelection.getSelectionLabels(selectionEnd, selectionStart);
    }
}

