/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.remmintan.gobi.Selection;
import net.remmintan.gobi.helpers.TreeBlocks;
import net.remmintan.gobi.helpers.TreeHelper;
import net.remmintan.mods.minefortress.core.TaskType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundCutTreesTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;

public class TreeSelection
extends Selection {
    private class_2338 start;
    private class_2338 end;
    private final List<class_2338> treeRoots = new ArrayList<class_2338>();
    private final List<class_2338> selectedTreeBlocks = new ArrayList<class_2338>();

    @Override
    public boolean isSelecting() {
        return this.start != null;
    }

    @Override
    public boolean needUpdate(class_2338 pickedBlock, int upDelta) {
        return this.start != null && !Objects.equals(pickedBlock, this.end);
    }

    @Override
    public boolean selectBlock(class_1937 level, class_1792 mainHandItem, class_2338 pickedBlock, int upDelta, ClickType click, class_634 clientPacketListener, class_239 hitResult) {
        if (click == ClickType.BUILD) {
            return this.start != null;
        }
        if (this.start == null) {
            this.start = pickedBlock;
            return false;
        }
        if (!this.treeRoots.isEmpty()) {
            this.selectedTreeBlocks.remove(this.start);
            UUID newTaskId = UUID.randomUUID();
            if (level instanceof ITasksInformationHolder) {
                ITasksInformationHolder holder = (ITasksInformationHolder)level;
                holder.get_ClientTasksHolder().addTask(newTaskId, this.getSelection(), TaskType.REMOVE);
            }
            ServerboundCutTreesTaskPacket packet = new ServerboundCutTreesTaskPacket(newTaskId, Collections.unmodifiableList(this.treeRoots));
            FortressClientNetworkHelper.send("fortress_cut_trees_task", packet);
        }
        return true;
    }

    @Override
    public void update(class_2338 pickedBlock, int upDelta) {
        if (this.start != null) {
            this.end = pickedBlock;
            this.updateSelection();
        }
    }

    @Override
    public List<class_2338> getSelection() {
        return this.selectedTreeBlocks;
    }

    @Override
    public void reset() {
        this.start = null;
        this.treeRoots.clear();
        this.selectedTreeBlocks.clear();
    }

    @Override
    public List<Pair<class_2382, class_2382>> getSelectionDimensions() {
        return Collections.emptyList();
    }

    private void updateSelection() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        this.updateTreeRoots((class_1937)world);
        this.updateTreeData((class_1937)world);
        if (this.start != null) {
            this.selectedTreeBlocks.add(this.start);
        }
    }

    private void updateTreeRoots(class_1937 world) {
        this.treeRoots.clear();
        if (this.start == null || this.end == null) {
            return;
        }
        int minY = Math.min(this.start.method_10264(), this.end.method_10264());
        class_2338 flatStart = new class_2338(this.start.method_10263(), minY, this.start.method_10260());
        class_2338 flatEnd = new class_2338(this.end.method_10263(), minY, this.end.method_10260());
        for (class_2338 pos : class_2338.method_10097((class_2338)flatStart, (class_2338)flatEnd)) {
            Optional<class_2338> rootDownFromLeaves;
            Optional<class_2338> rootDownFromLog;
            class_2680 blockState = world.method_8320(pos = pos.method_10062());
            if (blockState.method_26215()) continue;
            if (TreeHelper.isLog(blockState) && (rootDownFromLog = this.findRootDownFromLog(pos, world)).isPresent()) {
                this.treeRoots.add(rootDownFromLog.get());
                continue;
            }
            if ((blockState.method_26215() || TreeHelper.isLeaves(blockState)) && (rootDownFromLeaves = this.findRootDownFromAirOrLeaves(pos, world)).isPresent()) {
                this.treeRoots.add(rootDownFromLeaves.get());
                continue;
            }
            Optional<class_2338> rootUpFromGround = this.findRootUpFromGround(pos, world);
            rootUpFromGround.ifPresent(this.treeRoots::add);
        }
    }

    private void updateTreeData(class_1937 world) {
        this.selectedTreeBlocks.clear();
        for (class_2338 root : new ArrayList<class_2338>(this.treeRoots)) {
            Optional<TreeBlocks> treeBlocks = TreeHelper.getTreeBlocks(root, world);
            if (treeBlocks.isEmpty()) {
                this.treeRoots.remove(root);
                continue;
            }
            TreeBlocks tree = treeBlocks.get();
            this.selectedTreeBlocks.addAll(tree.getTreeBlocks());
            this.selectedTreeBlocks.addAll(tree.getLeavesBlocks());
        }
    }

    private Optional<class_2338> findRootDownFromLog(class_2338 start, class_1937 world) {
        class_2680 cursorState;
        class_2338 cursor = start;
        while (TreeHelper.isLog(cursorState = world.method_8320(cursor = cursor.method_10074()))) {
        }
        if (cursorState.method_26215()) {
            return Optional.empty();
        }
        return Optional.of(cursor.method_10084());
    }

    private Optional<class_2338> findRootDownFromAirOrLeaves(class_2338 start, class_1937 world) {
        class_2680 cursorState;
        class_2338 cursor = start;
        while ((cursorState = world.method_8320(cursor = cursor.method_10074())).method_26215() || TreeHelper.isLeaves(cursorState)) {
        }
        if (TreeHelper.isLog(cursorState)) {
            return this.findRootDownFromLog(cursor, world);
        }
        return Optional.empty();
    }

    private Optional<class_2338> findRootUpFromGround(class_2338 start, class_1937 world) {
        class_2680 cursorState;
        class_2338 cursor = start;
        while (!TreeHelper.isLog(cursorState = world.method_8320(cursor = cursor.method_10084())) && !cursorState.method_26215()) {
        }
        if (TreeHelper.isLog(cursorState)) {
            return Optional.of(cursor);
        }
        return Optional.empty();
    }
}

