/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi;

import com.mojang.datafixers.util.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.remmintan.gobi.RoadsSelection;
import net.remmintan.gobi.SelectionType;
import net.remmintan.gobi.TreeSelection;
import net.remmintan.gobi.TwoDotsSelection;
import net.remmintan.mods.minefortress.building.BuildingHelper;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientFortressManager;
import net.remmintan.mods.minefortress.core.interfaces.client.IClientManagersProvider;
import net.remmintan.mods.minefortress.core.interfaces.resources.IClientResourceManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelection;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionManager;
import net.remmintan.mods.minefortress.core.interfaces.selections.ISelectionType;
import net.remmintan.mods.minefortress.core.utils.CoreModUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class SelectionManager
implements ISelectionManager {
    private final class_310 client;
    private int selectionTypeIndex = 0;
    private ISelectionType currentSelectionType = SelectionType.SQUARES;
    private ISelection selection = new TwoDotsSelection();
    private ClickType clickType;
    private class_2680 clickingBlockState = null;
    private int upSelectionDelta = 0;
    private boolean needsUpdate = false;
    private boolean inCorrectState = true;

    public SelectionManager(class_310 client) {
        this.client = client;
    }

    @Override
    @Nullable
    public class_2680 getClickingBlock() {
        return this.clickingBlockState;
    }

    @Override
    public List<class_2338> getSelectedBlocks() {
        return this.selection.getSelection();
    }

    @Override
    public void selectBlock(class_2338 blockPos) {
        this.selectBlock(blockPos, ClickType.REMOVE, null);
    }

    @Override
    public void selectBlock(class_2338 blockPos, class_2680 blockState) {
        this.selectBlock(blockPos, ClickType.BUILD, blockState);
    }

    @Override
    public void moveSelectionUp() {
        ++this.upSelectionDelta;
    }

    @Override
    public void moveSelectionDown() {
        --this.upSelectionDelta;
    }

    @Override
    public void tickSelectionUpdate(@Nullable class_2338 blockPos, class_2350 clickedFace) {
        if (blockPos == null) {
            return;
        }
        if (this.isNotOverworld()) {
            if (this.selection.isSelecting()) {
                this.resetSelection();
            }
            return;
        }
        class_2338 pickedPos = this.clickType == ClickType.BUILD ? (BuildingHelper.canPlaceBlock((class_1937)this.client.field_1687, blockPos) ? blockPos : blockPos.method_10093(clickedFace)) : blockPos;
        if (this.selection.needUpdate(pickedPos, this.upSelectionDelta)) {
            this.selection.update(pickedPos, this.upSelectionDelta);
            this.setNeedsUpdate(true);
            IClientManagersProvider provider = CoreModUtils.getMineFortressManagersProvider();
            IClientFortressManager clientManager = provider.get_ClientFortressManager();
            if ((this.clickType == ClickType.BUILD || this.clickType == ClickType.ROADS) && this.clickingBlockState != null) {
                if (clientManager.isSurvival()) {
                    if (SelectionManager.isCountableBlock(this.clickingBlockState)) {
                        int blocksAmount = this.selection.getSelection().size();
                        class_1792 item = this.clickingBlockState.method_26204().method_8389();
                        IClientResourceManager resourceManager = clientManager.getResourceManager();
                        class_1799 itemStack = new class_1799((class_1935)item, blocksAmount);
                        this.inCorrectState = resourceManager.hasStacks(Collections.singletonList(itemStack));
                    } else {
                        this.inCorrectState = true;
                    }
                } else {
                    this.inCorrectState = true;
                }
            } else {
                this.inCorrectState = true;
            }
            provider.get_InfluenceManager().getFortressBorder().ifPresent(this::lambda$tickSelectionUpdate$0);
        }
    }

    @Override
    public Vector4f getClickColor() {
        if (!this.inCorrectState) {
            return new Vector4f(0.6666667f, 0.0f, 0.0f, 0.5f);
        }
        float green = this.clickType == ClickType.BUILD || this.clickType == ClickType.ROADS ? 0.6666667f : 0.0f;
        return new Vector4f(0.0f, green, 0.0f, 0.5f);
    }

    @Override
    public List<Pair<class_2382, class_2382>> getSelectionDimensions() {
        return this.selection.getSelectionDimensions();
    }

    private static boolean isCountableBlock(class_2680 state) {
        if (!state.method_26227().method_15769()) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (block == class_2246.field_10036) {
            return false;
        }
        if (block == class_2246.field_10124) {
            return false;
        }
        return block != class_2246.field_10499;
    }

    @Override
    public void toggleSelectionType() {
        this.upSelectionDelta = 0;
        this.resetSelection();
        ISelectionType[] types = (ISelectionType[])Arrays.stream(SelectionType.values()).filter(type -> type != SelectionType.TREE).filter(type -> type != SelectionType.ROADS).toArray(ISelectionType[]::new);
        if (++this.selectionTypeIndex >= types.length) {
            this.selectionTypeIndex = 0;
        }
        this.currentSelectionType = types[this.selectionTypeIndex];
        this.selection = this.currentSelectionType.generate();
    }

    @Override
    public void setSelectionType(ISelectionType type) {
        this.upSelectionDelta = 0;
        this.resetSelection();
        this.currentSelectionType = type;
        this.selectionTypeIndex = type.ordinal();
        this.selection = this.currentSelectionType.generate();
    }

    @Override
    public ISelectionType getCurrentSelectionType() {
        return this.currentSelectionType;
    }

    private void selectBlock(class_2338 blockPos, ClickType click, class_2680 blockState) {
        if (this.isNotOverworld()) {
            return;
        }
        if ((blockState == null || this.selection instanceof TreeSelection) && click == ClickType.BUILD) {
            this.resetSelection();
            return;
        }
        this.clickType = click;
        this.clickingBlockState = blockState;
        class_1792 mainHandItem = Optional.ofNullable(this.client.field_1724).map(it -> it.method_5998(class_1268.field_5808).method_7909()).orElse(null);
        if (this.selection instanceof RoadsSelection && this.clickType == ClickType.BUILD) {
            this.clickType = ClickType.ROADS;
        }
        if (this.selection.isSelecting() && !this.inCorrectState) {
            this.resetSelection();
            return;
        }
        boolean result = this.selection.selectBlock((class_1937)this.client.field_1687, mainHandItem, blockPos, this.upSelectionDelta, this.clickType, this.client.method_1562(), this.client.field_1765);
        if (result) {
            this.resetSelection();
        }
    }

    private boolean isNotOverworld() {
        class_638 level = this.client.field_1687;
        return level == null || level.method_27983() != class_1937.field_25179;
    }

    @Override
    public boolean isSelecting() {
        return this.selection.isSelecting();
    }

    @Override
    public void resetSelection() {
        if (!this.isSelecting()) {
            return;
        }
        this.selection.reset();
        this.clickType = null;
        this.upSelectionDelta = 0;
        this.inCorrectState = true;
    }

    @Override
    public ClickType getClickType() {
        return this.clickType;
    }

    @Override
    public List<Pair<class_243, String>> getLabels() {
        return this.selection != null ? this.selection.getSelectionLabelsPosition() : Collections.emptyList();
    }

    @Override
    public int getSelectionTypeIndex() {
        return this.selectionTypeIndex;
    }

    @Override
    public boolean isNeedsUpdate() {
        return this.needsUpdate;
    }

    @Override
    public void setNeedsUpdate(boolean needsUpdate) {
        this.needsUpdate = needsUpdate;
    }

    @Override
    public boolean isInCorrectState() {
        return this.inCorrectState;
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$tickSelectionUpdate$0(class_2784 border) {
        if (!this.inCorrectState) ** GOTO lbl-1000
        if (this.selection.getSelection().stream().allMatch((Predicate<class_2338>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, method_11952(net.minecraft.class_2338 ), (Lnet/minecraft/class_2338;)Z)((class_2784)border))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.inCorrectState = v0;
    }
}

