/*
 * Decompiled with CFR 0.152.
 */
package net.remmintan.gobi;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.remmintan.gobi.WallsSelection;
import net.remmintan.mods.minefortress.core.interfaces.selections.ClickType;
import net.remmintan.mods.minefortress.core.interfaces.tasks.IClientTasksHolder;
import net.remmintan.mods.minefortress.core.interfaces.tasks.ITasksInformationHolder;
import net.remmintan.mods.minefortress.networking.c2s.ServerboundRoadsTaskPacket;
import net.remmintan.mods.minefortress.networking.helpers.FortressClientNetworkHelper;

public class RoadsSelection
extends WallsSelection {
    @Override
    public boolean selectBlock(class_1937 level, class_1792 mainHandItem, class_2338 pickedBlock, int upDelta, ClickType click, class_634 connection, class_239 hitResult) {
        if (click == ClickType.REMOVE) {
            return true;
        }
        if (this.corners.isEmpty()) {
            this.corners.add(pickedBlock.method_10062());
            return false;
        }
        UUID digTaskId = UUID.randomUUID();
        UUID placeTaskId = UUID.randomUUID();
        IClientTasksHolder tasksHolder = ((ITasksInformationHolder)level).get_ClientTasksHolder();
        tasksHolder.addRoadsSelectionTask(digTaskId, placeTaskId, this.getSelection());
        ServerboundRoadsTaskPacket packet = new ServerboundRoadsTaskPacket(digTaskId, placeTaskId, this.selection);
        FortressClientNetworkHelper.send("fortress_roads_task", packet);
        return true;
    }

    @Override
    protected List<class_2338> getSelection(int upDelta, ArrayList<Pair<class_2338, class_2338>> cornerPairs) {
        class_638 world = class_310.method_1551().field_1687;
        if (Objects.isNull(world)) {
            return Collections.emptyList();
        }
        return cornerPairs.stream().map(p -> {
            class_2338 start = (class_2338)p.getFirst();
            class_2338 end = (class_2338)p.getSecond();
            class_2338 flatEnd = new class_2338(end.method_10263(), start.method_10264() + upDelta, end.method_10260());
            class_2338 direction = flatEnd.method_10059((class_2382)start);
            int expandAmount = 1 + upDelta;
            if (direction.method_10260() == 0) {
                int sign = direction.method_10263() == 0 ? 0 : direction.method_10263() / Math.abs(direction.method_10263());
                class_2338 expandedStart = new class_2338(start.method_10263() - sign * expandAmount, start.method_10264(), start.method_10260() + expandAmount);
                class_2338 expandedEnd = new class_2338(flatEnd.method_10263(), flatEnd.method_10264(), flatEnd.method_10260() - expandAmount);
                return class_2338.method_10097((class_2338)expandedStart, (class_2338)expandedEnd);
            }
            if (direction.method_10263() == 0) {
                int sign = direction.method_10260() == 0 ? 0 : direction.method_10260() / Math.abs(direction.method_10260());
                class_2338 expandedStart = new class_2338(start.method_10263() + expandAmount, start.method_10264(), start.method_10260() - sign * expandAmount);
                class_2338 expandedEnd = new class_2338(flatEnd.method_10263() - expandAmount, flatEnd.method_10264(), flatEnd.method_10260());
                return class_2338.method_10097((class_2338)expandedStart, (class_2338)expandedEnd);
            }
            return null;
        }).filter(Objects::nonNull).flatMap(WallsSelection::iterableToList).map(pos -> {
            class_2680 blockState = world.method_8320(pos);
            while (this.isAir(blockState)) {
                pos = pos.method_10074();
                blockState = world.method_8320(pos);
            }
            while (!this.isAir(blockState)) {
                pos = pos.method_10084();
                blockState = world.method_8320(pos);
            }
            return pos.method_10074();
        }).toList();
    }

    private boolean isAir(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26164(class_3481.field_20339) || blockState.method_45474();
    }
}

