/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class MermodConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    public static double getSwimSpeedMultiplier() {
        return (Double)MermodConfig.SERVER.swimSpeedMultiplier.get();
    }

    public static boolean getWaterBreathing() {
        return (Boolean)MermodConfig.SERVER.waterBreathing.get();
    }

    public static boolean getNightVision() {
        return (Boolean)MermodConfig.SERVER.nightVision.get();
    }

    public static boolean getAquaAffinity() {
        return (Boolean)MermodConfig.SERVER.aquaAffinity.get();
    }

    public static boolean getNightVisionFlashingFix() {
        return (Boolean)MermodConfig.CLIENT.nightVisionFlashingFix.get();
    }

    public static boolean getReplaceSwimAnimation() {
        return (Boolean)MermodConfig.CLIENT.replaceSwimAnimation.get();
    }

    public static void setNightVisionFlashingFix(boolean value) {
        MermodConfig.CLIENT.nightVisionFlashingFix.set((Object)value);
    }

    public static void setReplaceSwimAnimation(boolean value) {
        MermodConfig.CLIENT.replaceSwimAnimation.set((Object)value);
    }

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER = (Server)serverPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverPair.getRight();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT = (Client)clientPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientPair.getRight();
    }

    public static class Server {
        public ForgeConfigSpec.DoubleValue swimSpeedMultiplier;
        public ForgeConfigSpec.BooleanValue waterBreathing;
        public ForgeConfigSpec.BooleanValue nightVision;
        public ForgeConfigSpec.BooleanValue aquaAffinity;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Server");
            this.swimSpeedMultiplier = builder.comment("Swim speed multiplier").defineInRange("swimSpeedMultiplier", 2.0, 1.0, 10.0);
            this.waterBreathing = builder.comment("Water breathing").define("waterBreathing", true);
            this.nightVision = builder.comment("Night vision").define("nightVision", true);
            this.aquaAffinity = builder.comment("Aqua affinity").define("aquaAffinity", true);
            builder.pop();
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue nightVisionFlashingFix;
        public ForgeConfigSpec.BooleanValue replaceSwimAnimation;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("Client");
            this.nightVisionFlashingFix = builder.comment("Night vision flashing fix").define("nightVisionFlashingFix", true);
            this.replaceSwimAnimation = builder.comment("Replace swim animation").define("replaceSwimAnimation", true);
            builder.pop();
        }
    }
}

