/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.easybuilder;

import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.registry.result.SupplierResult;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.tile.BlockEntityTypeBuilder;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityTypeWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.RewritableBlockEntityTypeWrapper;
import net.pitan76.mcpitanlib.midohra.easybuilder.built.BuiltBlockEntity;

public class BlockEntityBuilder {
    public BiConsumer<BlockEntityWrapper, WriteNbtArgs> onWriteNbt;
    public BiConsumer<BlockEntityWrapper, ReadNbtArgs> onReadNbt;
    public BiConsumer<BlockEntityWrapper, BlockEntityBuilder> onInit;
    public CompatIdentifier id;

    public BlockEntityBuilder(CompatIdentifier id) {
        this.id = id;
    }

    public static BlockEntityBuilder of(CompatIdentifier id) {
        return new BlockEntityBuilder(id);
    }

    public BlockEntityTypeWrapper build(CompatRegistryV2 registry, CompatIdentifier id, BlockWrapper ... blocks) {
        RewritableBlockEntityTypeWrapper type = RewritableBlockEntityTypeWrapper.of();
        BlockEntityBuilder builder = this;
        SupplierResult<class_2591<class_2586>> result = registry.registerBlockEntityType(id, BlockEntityTypeBuilder.create(e -> new BuiltBlockEntity(type, builder, e), (class_2248[])Arrays.stream(blocks).map(BlockWrapper::get).toArray(class_2248[]::new)));
        type.set(result.get());
        return type;
    }

    public BlockEntityTypeWrapper build(CompatRegistryV2 registry, BlockWrapper ... blocks) {
        if (this.id == null) {
            throw new IllegalStateException("BlockEntity id is not set. hint: use build(CompatRegistryV2, CompatIdentifier, BlockWrapper...)");
        }
        return this.build(registry, this.id, blocks);
    }

    public BlockEntityBuilder onInit(BiConsumer<BlockEntityWrapper, BlockEntityBuilder> onInit) {
        this.onInit = onInit;
        return this;
    }

    public BlockEntityBuilder onWriteNbt(BiConsumer<BlockEntityWrapper, WriteNbtArgs> onWriteNbt) {
        this.onWriteNbt = onWriteNbt;
        return this;
    }

    public BlockEntityBuilder onReadNbt(BiConsumer<BlockEntityWrapper, ReadNbtArgs> onReadNbt) {
        this.onReadNbt = onReadNbt;
        return this;
    }

    public BlockEntityBuilder write(BlockEntityBuilder copy) {
        copy.onInit = this.onInit;
        copy.onWriteNbt = this.onWriteNbt;
        copy.onReadNbt = this.onReadNbt;
        return copy;
    }

    public BlockEntityBuilder copy(CompatIdentifier id) {
        return this.write(new BlockEntityBuilder(id));
    }

    public BlockEntityBuilder copy() {
        return this.copy(this.id);
    }
}

