/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.collection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.pitan76.mcpitanlib.api.gui.inventory.IInventory;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackList
extends class_2371<class_1799> {
    public ItemStackList(List<class_1799> delegate, @Nullable class_1799 initialElement) {
        super(delegate, (Object)initialElement);
    }

    public static ItemStackList of() {
        return new ItemStackList(Lists.newArrayList(), ItemStackUtil.empty());
    }

    public static ItemStackList ofSize(int size) {
        return ItemStackList.ofSize(size, ItemStackUtil.empty());
    }

    public static ItemStackList ofSize(int size, class_1799 defaultStack) {
        Validate.notNull((Object)defaultStack);
        Object[] objects = new class_1799[size];
        Arrays.fill(objects, defaultStack);
        return new ItemStackList(Arrays.asList(objects), defaultStack);
    }

    public static ItemStackList copyOf(class_1799 defaultStack, class_1799 ... stacks) {
        return new ItemStackList(Arrays.asList(stacks), defaultStack);
    }

    public static class_1263 toInventory(class_2371<class_1799> list) {
        return IInventory.of(list);
    }

    public static class_2371<class_1799> toDefaultedList(class_1263 inventory) {
        class_2371 list = class_2371.method_10213((int)inventory.method_5439(), (Object)ItemStackUtil.empty());
        for (int i = 0; i < inventory.method_5439(); ++i) {
            list.set(i, (Object)inventory.method_5438(i));
        }
        return list;
    }

    public static ItemStackList fromInventory(class_1263 inventory) {
        return new ItemStackList((List<class_1799>)ItemStackList.toDefaultedList(inventory), ItemStackUtil.empty());
    }

    public class_1263 toInventory() {
        return ItemStackList.toInventory(this);
    }

    public class_2371<class_1799> defaultedList() {
        return this;
    }

    public static ItemStackList of(class_2371<class_1799> defaultedList) {
        ItemStackList stacks = ItemStackList.ofSize(defaultedList.size());
        for (int i = 0; i < defaultedList.size(); ++i) {
            stacks.set(i, (class_1799)defaultedList.get(i));
        }
        return stacks;
    }

    public static ItemStackList of(class_1799 stack) {
        return ItemStackList.ofSize(1, stack);
    }

    public List<ItemStack> toMidohra() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            class_1799 stack = (class_1799)iterator.next();
            stacks.add(ItemStack.of(stack));
        }
        return stacks;
    }

    @NotNull
    public ItemStack getAsMidohra(int index) {
        return ItemStack.of((class_1799)this.get(index));
    }

    public ItemStack getFirstAsMidohra() {
        return this.getAsMidohra(0);
    }

    public ItemStack getLastAsMidohra() {
        return this.getAsMidohra(this.size() - 1);
    }

    public boolean add(ItemStack stack) {
        return this.add(stack.toMinecraft());
    }

    public boolean addAll(List<ItemStack> stacks) {
        boolean changed = false;
        for (ItemStack stack : stacks) {
            changed |= this.add(stack);
        }
        return changed;
    }

    public boolean addAll(ItemStack ... stacks) {
        return this.addAll(Arrays.asList(stacks));
    }

    public boolean remove(ItemStack stack) {
        return this.remove(stack.toMinecraft());
    }

    public boolean removeAll(List<ItemStack> stacks) {
        boolean changed = false;
        for (ItemStack stack : stacks) {
            changed |= this.remove(stack);
        }
        return changed;
    }

    public boolean removeAll(ItemStack ... stacks) {
        return this.removeAll(Arrays.asList(stacks));
    }

    public boolean contains(ItemStack stack) {
        return this.contains(stack.toMinecraft());
    }

    public boolean containsAll(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (this.contains(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ItemStack ... stacks) {
        return this.containsAll(Arrays.asList(stacks));
    }

    public boolean containsAny(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!this.contains(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(ItemStack ... stacks) {
        return this.containsAny(Arrays.asList(stacks));
    }

    public boolean equals(List<ItemStack> stacks) {
        if (this.size() != stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((class_1799)this.get(i)).equals(stacks.get(i).toMinecraft())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ItemStack ... stacks) {
        return this.equals(Arrays.asList(stacks));
    }

    public static ItemStackList of(List<ItemStack> stacks) {
        ItemStackList list = ItemStackList.ofSize(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            list.set(i, stacks.get(i).toMinecraft());
        }
        return list;
    }

    public static ItemStackList of(ItemStack ... stacks) {
        return ItemStackList.of(Arrays.asList(stacks));
    }

    public static ItemStackList of(ItemStack stack) {
        return ItemStackList.of(stack, 1);
    }

    public static ItemStackList of(ItemStack stack, int size) {
        return ItemStackList.ofSize(size, stack.toMinecraft());
    }

    public static ItemStackList of2(List<class_1799> stacks) {
        ItemStackList list = ItemStackList.ofSize(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            list.set(i, stacks.get(i));
        }
        return list;
    }
}

