/*
 * Decompiled with CFR 0.152.
 */
package more_rpg_loot.entity.mob;

import com.github.thedeathlycow.thermoo.api.ThermooAttributes;
import java.util.EnumSet;
import java.util.Random;
import more_rpg_loot.client.particle.Particles;
import more_rpg_loot.effects.Effects;
import more_rpg_loot.entity.projectile.FrostballEntity;
import more_rpg_loot.sounds.ModSounds;
import more_rpg_loot.util.HelperMethods;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1370;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class GlazeEntity
extends class_1588 {
    private float eyeOffset = 0.5f;
    private int eyeOffsetCooldown;

    public GlazeEntity(class_1299<? extends GlazeEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_14, 8.0f);
        this.method_5941(class_7.field_9, 0.0f);
        this.method_5941(class_7.field_3, 0.0f);
        this.field_6194 = 10;
    }

    protected void method_5959() {
        this.field_6201.method_6277(4, (class_1352)new GlazeSpecialAttacksGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1370((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createGlazeAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23719, (double)0.23f).method_26868(class_5134.field_23717, 48.0);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        class_1315 entityData2 = super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        if (FabricLoader.getInstance().isModLoaded("thermoo")) {
            this.method_5996(ThermooAttributes.MIN_TEMPERATURE).method_6192(5.0);
            this.method_5996(ThermooAttributes.FROST_RESISTANCE).method_6192(10.0);
        }
        return entityData2;
    }

    protected void method_5693() {
        super.method_5693();
    }

    protected class_3414 method_5994() {
        return ModSounds.ENTITY_GLAZE_AMBIENT_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.ENTITY_GLAZE_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return ModSounds.ENTITY_GLAZE_DEATH_EVENT;
    }

    public float method_5718() {
        return 1.0f;
    }

    public void method_6007() {
        if (!this.method_24828() && this.method_18798().field_1351 < 0.0) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (this.method_37908().field_9236) {
            if (this.field_5974.method_43048(24) == 0 && !this.method_5701()) {
                this.method_37908().method_8486(this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5, ModSounds.ENTITY_GLAZE_FREEZE_EVENT, this.method_5634(), 1.0f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23322(1.5), this.method_23319(), this.method_23325(1.5), 0.0, -0.1, 0.0);
                this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.method_6007();
    }

    public boolean method_29503() {
        return false;
    }

    protected void method_5958() {
        class_1309 livingEntity;
        --this.eyeOffsetCooldown;
        if (this.eyeOffsetCooldown <= 0) {
            this.eyeOffsetCooldown = 100;
            this.eyeOffset = (float)this.field_5974.method_43385(0.5, 6.891);
        }
        if ((livingEntity = this.method_5968()) != null && livingEntity.method_23320() > this.method_23320() + (double)this.eyeOffset && this.method_18395(livingEntity)) {
            class_243 vec3d = this.method_18798();
            this.method_18799(this.method_18798().method_1031(0.0, ((double)0.3f - vec3d.field_1351) * (double)0.3f, 0.0));
            this.field_6007 = true;
        }
        super.method_5958();
    }

    public boolean method_6121(class_1297 target) {
        if (super.method_6121(target)) {
            if (target instanceof class_1309) {
                class_1309 entity = (class_1309)target;
                HelperMethods.stackFreezeStacks(entity, 20);
            }
            return true;
        }
        return false;
    }

    private static class GlazeSpecialAttacksGoal
    extends class_1352 {
        private final GlazeEntity glaze;
        private int frostballsHailFired;
        private int frostballHailCooldown;
        private int frostStormCooldown;
        private int targetNotVisibleTicks;

        public GlazeSpecialAttacksGoal(GlazeEntity glaze) {
            this.glaze = glaze;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = this.glaze.method_5968();
            return livingEntity != null && livingEntity.method_5805() && this.glaze.method_18395(livingEntity);
        }

        public void method_6269() {
            this.frostballsHailFired = 0;
        }

        public void method_6270() {
            this.targetNotVisibleTicks = 0;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            --this.frostballHailCooldown;
            --this.frostStormCooldown;
            double followRangeSquare = this.getFollowRange() * this.getFollowRange();
            double frostStormRange = 40.0;
            class_1309 livingEntity = this.glaze.method_5968();
            if (livingEntity != null) {
                boolean bl = this.glaze.method_5985().method_6369((class_1297)livingEntity);
                this.targetNotVisibleTicks = bl ? 0 : ++this.targetNotVisibleTicks;
                double d = this.glaze.method_5858((class_1297)livingEntity);
                if (d < 4.0) {
                    if (!bl) {
                        return;
                    }
                    this.glaze.method_6121((class_1297)livingEntity);
                    this.glaze.method_5962().method_6239(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), 1.0);
                } else if (d < followRangeSquare & d > frostStormRange && bl) {
                    if (this.frostballHailCooldown <= 0) {
                        ++this.frostballsHailFired;
                        if (this.frostballsHailFired == 1) {
                            this.frostballHailCooldown = 60;
                        } else if (this.frostballsHailFired <= 3) {
                            this.frostballHailCooldown = 6;
                        } else {
                            this.frostballHailCooldown = 100;
                            this.frostballsHailFired = 0;
                        }
                        if (this.frostballsHailFired > 1) {
                            for (int i = 0; i < 1; ++i) {
                                Random rand = new Random();
                                float random = rand.nextFloat() * 0.025f + 0.0f;
                                float randomDivergence = rand.nextFloat() * 0.5f + 0.0f;
                                float randomHeight = rand.nextFloat() * 2.0f + 1.0f;
                                FrostballEntity frostballEntity = new FrostballEntity(livingEntity.method_37908(), livingEntity);
                                frostballEntity.method_7432((class_1297)this.glaze);
                                frostballEntity.method_5814(livingEntity.method_23317() + (double)random, livingEntity.method_23323((double)randomHeight) + 0.5, livingEntity.method_23321() + (double)random);
                                frostballEntity.method_24919((class_1297)frostballEntity, frostballEntity.method_36455(), frostballEntity.method_36454(), random, random, randomDivergence);
                                this.glaze.method_37908().method_8649((class_1297)frostballEntity);
                            }
                        }
                    }
                    this.glaze.method_5988().method_6226((class_1297)livingEntity, 10.0f, 10.0f);
                } else if (d < frostStormRange && bl) {
                    if (this.frostStormCooldown <= 0 && !this.glaze.method_37908().field_9236) {
                        HelperMethods.spawnCloudEntity((class_2394)Particles.FREEZING_SNOWFLAKE, (class_1297)this.glaze, 4.0f, 5, 5.0f, Effects.FREEZING, 3, 1);
                        this.frostStormCooldown = 600;
                    }
                } else if (this.targetNotVisibleTicks < 5) {
                    this.glaze.method_5962().method_6239(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), 1.0);
                }
                super.method_6268();
            }
        }

        private double getFollowRange() {
            return this.glaze.method_26825(class_5134.field_23717);
        }
    }
}

