/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.fabric;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.ModConfig;
import dev.obscuria.lootjournal.client.DefaultBehavior;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.minecraft.class_1269;
import org.apache.commons.compress.utils.Lists;

@Config(name="obscuria/loot_journal-client")
public final class FabricConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
    public Display display = new Display();
    @ConfigEntry.Gui.CollapsibleObject
    public Positioning positioning = new Positioning();
    @ConfigEntry.Gui.CollapsibleObject
    public Filtering filtering = new Filtering();

    public static void init() {
        ConfigHolder configHolder = AutoConfig.register(FabricConfig.class, Toml4jConfigSerializer::new);
        configHolder.registerLoadListener(FabricConfig::onUpdate);
        configHolder.registerSaveListener(FabricConfig::onUpdate);
        configHolder.load();
    }

    public static class_1269 onUpdate(ConfigHolder<FabricConfig> holder, FabricConfig config) {
        LootJournal.CONFIG.style = config.display.style;
        LootJournal.CONFIG.useRarityColor = config.display.useRarityColor;
        LootJournal.CONFIG.itemsColor = config.display.itemsColor;
        LootJournal.CONFIG.groupedItemsColor = config.display.groupedItemsColor;
        LootJournal.CONFIG.experienceColor = config.display.experienceColor;
        LootJournal.CONFIG.displayExperience = config.display.displayExperience;
        LootJournal.CONFIG.displayTotal = config.display.displayTotal;
        LootJournal.CONFIG.anchor = config.positioning.anchor;
        LootJournal.CONFIG.anchorOffset = config.positioning.anchorOffset;
        LootJournal.CONFIG.notificationSeparation = config.positioning.notificationSeparation;
        LootJournal.CONFIG.notificationLifetime = config.positioning.notificationLifetime;
        LootJournal.CONFIG.maxVisibleNotifications = config.positioning.maxVisibleNotifications;
        LootJournal.CONFIG.maxQueuedNotifications = config.positioning.maxQueuedNotifications;
        LootJournal.CONFIG.defaultBehavior = config.filtering.defaultBehavior;
        LootJournal.CONFIG.tabsBlacklist = ModConfig.mapTabs(config.filtering.tabsBlacklist);
        LootJournal.CONFIG.itemsBlacklist = ModConfig.mapItems(config.filtering.itemsBlacklist);
        LootJournal.CONFIG.tabsWhitelist = ModConfig.mapTabs(config.filtering.tabsWhitelist);
        LootJournal.CONFIG.itemsWhitelist = ModConfig.mapItems(config.filtering.itemsWhitelist);
        return class_1269.field_5812;
    }

    public static final class Display {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Style style = ModConfig.STYLE;
        public boolean useRarityColor = true;
        @ConfigEntry.ColorPicker
        public int itemsColor = 0xFFFFFF;
        @ConfigEntry.ColorPicker
        public int groupedItemsColor = 0xFFFFFF;
        @ConfigEntry.ColorPicker
        public int experienceColor = 0x55FF55;
        public boolean displayExperience = true;
        public boolean displayTotal = true;
    }

    public static final class Positioning {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Anchor anchor = Anchor.BOTTOM_RIGHT;
        @ConfigEntry.BoundedDiscrete(min=0L, max=256L)
        public int anchorOffset = 3;
        @ConfigEntry.BoundedDiscrete(min=0L, max=16L)
        public int notificationSeparation = 3;
        @ConfigEntry.BoundedDiscrete(min=0L, max=32L)
        public int notificationLifetime = 6;
        @ConfigEntry.BoundedDiscrete(min=1L, max=64L)
        public int maxVisibleNotifications = 12;
        @ConfigEntry.BoundedDiscrete(min=0L, max=256L)
        public int maxQueuedNotifications = 23;
    }

    public static final class Filtering {
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DefaultBehavior defaultBehavior = ModConfig.DEFAULT_BEHAVIOR;
        public List<String> tabsBlacklist = Lists.newArrayList();
        public List<String> itemsBlacklist = Lists.newArrayList();
        public List<String> tabsWhitelist = Lists.newArrayList();
        public List<String> itemsWhitelist = Lists.newArrayList();
    }
}

