/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import dev.obscuria.lootjournal.client.render.Anchor;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public enum Style {
    CLASSIC(Style::renderClassic),
    FLAT(Style::renderFlat),
    TEXT(Style::renderText);

    private static final class_2960 DECORATIONS;
    private final Renderer renderer;

    private Style(Renderer renderer) {
        this.renderer = renderer;
    }

    public void render(IPickup pickup, class_332 graphics, Anchor anchor, int x, int y, double ratio, long time) {
        class_327 font = class_310.method_1551().field_1772;
        double actualX = (double)x + Style.getOffset(ratio, anchor.isReversed());
        class_5250 name = pickup.getDisplayName();
        int nameWidth = font.method_27525((class_5348)name);
        class_5250 total = pickup.shouldDisplayTotal() ? class_2561.method_43470((String)String.valueOf(pickup.getTotal())) : class_2561.method_43473();
        int totalWidth = pickup.shouldDisplayTotal() ? font.method_27525((class_5348)total) + 5 : 0;
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(actualX, (double)y, 400.0);
        RenderSystem.enableBlend();
        this.renderer.render(pickup, graphics, anchor, font, name, nameWidth, total, totalWidth, actualX, y, time);
        RenderSystem.disableBlend();
        graphics.method_51448().method_22909();
    }

    private static void renderClassic(IPickup pickup, class_332 graphics, Anchor anchor, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.method_25290(DECORATIONS, -36 - nameWidth - totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.method_25290(DECORATIONS, -26 - totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.method_27535(font, (class_2561)name, -29 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_25290(DECORATIONS, -218 + nameWidth + totalWidth, 0, 0.0f, 0.0f, 256, 12, 256, 256);
            graphics.method_25290(DECORATIONS, -230 + totalWidth, 1, 0.0f, 12.0f, 256, 10, 256, 256);
            graphics.method_27535(font, (class_2561)name, 30 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderFlat(IPickup pickup, class_332 graphics, Anchor anchor, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.method_25294(-3, 0, -25 - nameWidth - totalWidth, 12, Integer.MIN_VALUE);
            graphics.method_27535(font, (class_2561)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_25294(3, 0, 25 + nameWidth + totalWidth, 12, Integer.MIN_VALUE);
            graphics.method_27535(font, (class_2561)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderText(IPickup pickup, class_332 graphics, Anchor anchor, class_327 font, class_5250 name, int nameWidth, class_5250 total, int totalWidth, double x, double y, long time) {
        if (anchor.isReversed()) {
            graphics.method_27535(font, (class_2561)name, -23 - nameWidth - totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), -totalWidth, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, -11 - totalWidth, 6.0, time);
        } else {
            graphics.method_27535(font, (class_2561)name, 23 + totalWidth, 2, 0xFFFFFF);
            graphics.method_27535(font, (class_2561)total.method_27692(class_124.field_1080), 5, 2, 0xFFFFFF);
            Style.renderIcon(pickup, graphics, 11 + totalWidth, 6.0, time);
        }
    }

    private static void renderIcon(IPickup pickup, class_332 graphics, double x, double y, long time) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(x, y, 0.0);
        pickup.renderIcon(graphics, time);
        graphics.method_51448().method_22909();
    }

    private static class_2561 getName(String raw, int count) {
        if (((String)raw).length() > 24) {
            raw = ((String)raw).substring(0, 23) + "...";
        }
        return class_2561.method_43470((String)((String)raw + " x" + count));
    }

    private static double getOffset(double factor, boolean inverted) {
        double offset = -220.0 + 220.0 * (1.0 - Math.pow(factor - 1.0, 2.0));
        return inverted ? -offset : offset;
    }

    static {
        DECORATIONS = LootJournal.key("textures/gui/decorations.png");
    }

    @FunctionalInterface
    private static interface Renderer {
        public void render(IPickup var1, class_332 var2, Anchor var3, class_327 var4, class_5250 var5, int var6, class_5250 var7, int var8, double var9, double var11, long var13);
    }
}

