/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.ExperiencePickup;
import dev.obscuria.lootjournal.client.pickup.GroupedItemsPickup;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import dev.obscuria.lootjournal.client.pickup.ItemPickup;
import dev.obscuria.lootjournal.client.render.Anchor;
import dev.obscuria.lootjournal.client.render.Style;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public final class PickupComponent {
    private static final HashMap<Integer, PickupInstance> occupied = Maps.newHashMap();
    private static final List<PickupInstance> visible = Lists.newArrayList();
    private static final Deque<IPickup> queued = Queues.newArrayDeque();

    public static void render(class_332 graphics) {
        class_1041 window = class_310.method_1551().method_22683();
        int maxVisible = LootJournal.CONFIG.maxVisibleNotifications;
        Style style = LootJournal.CONFIG.style;
        Anchor anchor = LootJournal.CONFIG.anchor;
        int originX = anchor.originX(window);
        int originY = anchor.originY(window);
        int step = anchor.step();
        visible.removeIf(instance -> {
            if (!instance.render(graphics, style, anchor, originX, originY + step * instance.index)) {
                return false;
            }
            occupied.remove(instance.index);
            return true;
        });
        if (queued.isEmpty() || visible.size() >= maxVisible) {
            return;
        }
        queued.removeIf(pickup -> {
            int index = PickupComponent.findFreeIndex(maxVisible);
            if (index <= -1) {
                return false;
            }
            PickupInstance instance = new PickupInstance((IPickup)pickup, index);
            visible.add(instance);
            occupied.put(index, instance);
            return true;
        });
    }

    public static void appendItem(int itemId, int playerId, int amount) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_5628() != playerId) {
            return;
        }
        class_1297 class_12972 = player.method_37908().method_8469(itemId);
        if (!(class_12972 instanceof class_1542)) {
            return;
        }
        class_1542 entity = (class_1542)class_12972;
        class_1799 stack = entity.method_6983().method_7972();
        stack.method_7939(amount);
        PickupComponent.appendItem(stack);
    }

    public static void appendItem(class_1799 stack) {
        if (!LootJournal.isAllowed(stack)) {
            return;
        }
        int maxVisible = LootJournal.CONFIG.maxVisibleNotifications;
        int maxQueued = LootJournal.CONFIG.maxQueuedNotifications;
        PickupComponent.append(visible.size() > maxVisible && queued.size() > maxQueued ? new GroupedItemsPickup(stack) : new ItemPickup(stack));
    }

    public static void appendExperience(int amount) {
        if (!LootJournal.CONFIG.displayExperience) {
            return;
        }
        PickupComponent.append(new ExperiencePickup(amount));
    }

    private static void append(IPickup pickup) {
        if (PickupComponent.tryMerge(pickup)) {
            return;
        }
        int index = PickupComponent.findFreeIndex(LootJournal.CONFIG.maxVisibleNotifications);
        if (index > -1) {
            PickupInstance instance = new PickupInstance(pickup, index);
            visible.add(instance);
            occupied.put(index, instance);
        } else if (queued.size() < LootJournal.CONFIG.maxQueuedNotifications) {
            queued.add(pickup);
        }
    }

    private static boolean tryMerge(IPickup pickup) {
        for (PickupInstance instance : visible) {
            if (!instance.tryMerge(pickup)) continue;
            return true;
        }
        for (IPickup other : queued) {
            if (!other.tryMerge(pickup)) continue;
            return true;
        }
        return false;
    }

    private static int findFreeIndex(int size) {
        for (int i = 0; i < size; ++i) {
            if (occupied.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    private static final class PickupInstance {
        private static final long FADE_IN = 750L;
        private static final long FADE_OUT = 1500L;
        private final IPickup pickup;
        private long startTime = -1L;
        private long lastTime;
        private double delta;
        private double ratio;
        public int index;

        public PickupInstance(IPickup pickup, int index) {
            this.pickup = pickup;
            this.index = index;
        }

        public boolean render(class_332 graphics, Style style, Anchor anchor, int x, int y) {
            long currentTime = class_156.method_658();
            if (this.startTime < 0L) {
                this.startTime = currentTime;
                this.lastTime = currentTime;
            }
            this.delta = (double)(currentTime - this.lastTime) / 1000.0;
            this.lastTime = currentTime;
            long time = currentTime - this.startTime;
            if (!class_310.method_1551().field_1690.field_1842) {
                style.render(this.pickup, graphics, anchor, x, y, this.ratio, time);
            }
            this.updateRatio(time);
            return time > this.getDisplayTime();
        }

        public boolean tryMerge(IPickup other) {
            if (this.pickup.tryMerge(other)) {
                this.startTime = class_156.method_658();
                return true;
            }
            return this.pickup.tryMerge(other);
        }

        private void updateRatio(long time) {
            if (time <= 750L) {
                this.ratio = Math.min(this.ratio + this.delta * 2.0, 1.0);
            }
            if (time >= this.getDisplayTime() - 1500L) {
                this.ratio = Math.max(this.ratio - this.delta, 0.0);
            }
        }

        private long getLifetime() {
            return (long)(1000.0 * LootJournal.CONFIG.notificationLifetime);
        }

        private long getDisplayTime() {
            return 2250L + this.getLifetime();
        }
    }
}

