/*
 * Decompiled with CFR 0.152.
 */
package dev.obscuria.lootjournal.client.pickup;

import dev.obscuria.lootjournal.LootJournal;
import dev.obscuria.lootjournal.client.pickup.IPickup;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.apache.commons.compress.utils.Lists;

public final class GroupedItemsPickup
implements IPickup {
    private final List<class_1799> stacks = Lists.newArrayList();
    private int count;

    public GroupedItemsPickup(class_1799 stack) {
        this.stacks.add(stack);
        this.count = stack.method_7947();
    }

    @Override
    public void renderIcon(class_332 graphics, long time) {
        if (this.stacks.isEmpty()) {
            return;
        }
        int interval = Math.max(200, 1000 - 50 * this.stacks.size());
        class_1799 stack = this.stacks.get((int)(time / (long)interval % (long)this.stacks.size()));
        graphics.method_51445(stack, -8, -8);
    }

    @Override
    public boolean tryMerge(IPickup pickup) {
        if (!(pickup instanceof GroupedItemsPickup)) {
            return false;
        }
        GroupedItemsPickup other = (GroupedItemsPickup)pickup;
        this.stacks.addAll(other.stacks);
        this.count += other.count;
        return true;
    }

    @Override
    public class_5250 getDisplayName() {
        return (this.count <= 1 ? class_2561.method_43471((String)"pickup.loot_journal.grouped_items_single") : class_2561.method_43469((String)"pickup.loot_journal.grouped_items_multiple", (Object[])new Object[]{this.count})).method_27696(class_2583.field_24360.method_36139(LootJournal.CONFIG.groupedItemsColor));
    }

    @Override
    public boolean shouldDisplayTotal() {
        return false;
    }

    @Override
    public int getTotal() {
        return 0;
    }
}

