/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3518;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record FluidIngredient(Value[] values) {
    public static final FluidIngredient WATER = new FluidIngredient(new Value[]{new TagValue((class_6862<class_3611>)class_3486.field_15517)});
    public static final Codec<FluidIngredient> CODEC = Codec.unit((Object)WATER);

    public boolean test(class_3610 state) {
        for (Value value : this.values) {
            if (!value.is(state)) continue;
            return true;
        }
        return false;
    }

    public class_3611[] getFluids() {
        return (class_3611[])Arrays.stream(this.values).flatMap(value -> value.getFluids().stream()).distinct().toArray(class_3611[]::new);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean canBeEmpty) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return FluidIngredient.fromValues(Stream.of(FluidIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonarray = json.getAsJsonArray();
                if (jsonarray.isEmpty() && !canBeEmpty) {
                    throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
                }
                return FluidIngredient.fromValues(StreamSupport.stream(jsonarray.spliterator(), false).map(it -> FluidIngredient.valueFromJson(class_3518.method_15295((JsonElement)it, (String)"fluid"))));
            }
            throw new JsonSyntaxException("Expected fluid to be object or array of objects");
        }
        throw new JsonSyntaxException("Fluid cannot be null");
    }

    private static FluidIngredient fromValues(Stream<? extends Value> stream) {
        return new FluidIngredient((Value[])stream.toArray(Value[]::new));
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag")));
            return new TagValue((class_6862<class_3611>)tag);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    public static FluidIngredient fromNetwork(class_2540 buffer) {
        return FluidIngredient.fromValues(buffer.method_34066(class_2540::method_10810).stream().map(arg_0 -> ((class_7922)class_7923.field_41173).method_10223(arg_0)).map(FluidValue::new));
    }

    public void toNetwork(class_2540 buffer) {
        buffer.method_34062(Arrays.asList(this.getFluids()), (buf, fluid) -> buf.method_10812(class_7923.field_41173.method_10221(fluid)));
    }

    public static interface Value {
        public boolean is(class_3610 var1);

        public Collection<class_3611> getFluids();
    }

    public record FluidValue(class_3611 fluid) implements Value
    {
        @Override
        public boolean is(class_3610 state) {
            return state.method_39360(this.fluid);
        }

        @Override
        public Collection<class_3611> getFluids() {
            return List.of(this.fluid);
        }
    }

    public record TagValue(class_6862<class_3611> tag) implements Value
    {
        @Override
        public boolean is(class_3610 state) {
            return state.method_15767(this.tag);
        }

        @Override
        public Collection<class_3611> getFluids() {
            ArrayList<class_3611> result = new ArrayList<class_3611>();
            for (class_6880 holder : class_7923.field_41173.method_40286(this.tag)) {
                result.add((class_3611)holder.comp_349());
            }
            return result;
        }
    }
}

