/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class ChunkLimitManager
extends class_18 {
    private static final String DATA_NAME = "littlejoys";
    private static final String FISHING_SPOT_CHUNKS = "FishingSpotChunks";
    private static final String DIG_SPOT_CHUNKS = "DigSpotChunks";
    private final Map<Long, Integer> fishingSpotCounts = new HashMap<Long, Integer>();
    private final Map<Long, Integer> digSpotCounts = new HashMap<Long, Integer>();

    public int getTotalFishingSpotsInChunk(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        return this.fishingSpotCounts.getOrDefault(chunkKey, 0);
    }

    public int getTotalDigSpotsInChunk(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        return this.digSpotCounts.getOrDefault(chunkKey, 0);
    }

    public void trackFishingSpot(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        Integer currentCount = this.fishingSpotCounts.getOrDefault(chunkKey, 0);
        this.fishingSpotCounts.put(chunkKey, currentCount + 1);
        this.method_80();
    }

    public void trackDigSpot(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        long chunkKey = chunkPos.method_8324();
        Integer currentCount = this.digSpotCounts.getOrDefault(chunkKey, 0);
        this.digSpotCounts.put(chunkKey, currentCount + 1);
        this.method_80();
    }

    public static ChunkLimitManager read(class_2487 tag) {
        int count;
        long chunkKey;
        ChunkLimitManager manager = new ChunkLimitManager();
        if (tag.method_10573(FISHING_SPOT_CHUNKS, 10)) {
            class_2487 fishingSpotsTag = tag.method_10562(FISHING_SPOT_CHUNKS);
            for (String key : fishingSpotsTag.method_10541()) {
                chunkKey = Long.parseLong(key);
                count = fishingSpotsTag.method_10550(key);
                manager.fishingSpotCounts.put(chunkKey, count);
            }
        }
        if (tag.method_10573(DIG_SPOT_CHUNKS, 10)) {
            class_2487 digSpotsTag = tag.method_10562(DIG_SPOT_CHUNKS);
            for (String key : digSpotsTag.method_10541()) {
                chunkKey = Long.parseLong(key);
                count = digSpotsTag.method_10550(key);
                manager.digSpotCounts.put(chunkKey, count);
            }
        }
        return manager;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2487 fishingSpotsTag = new class_2487();
        for (Map.Entry<Long, Integer> entry : this.fishingSpotCounts.entrySet()) {
            fishingSpotsTag.method_10569(String.valueOf(entry.getKey()), entry.getValue().intValue());
        }
        tag.method_10566(FISHING_SPOT_CHUNKS, (class_2520)fishingSpotsTag);
        class_2487 digSpotsTag = new class_2487();
        for (Map.Entry<Long, Integer> entry : this.digSpotCounts.entrySet()) {
            digSpotsTag.method_10569(String.valueOf(entry.getKey()), entry.getValue().intValue());
        }
        tag.method_10566(DIG_SPOT_CHUNKS, (class_2520)digSpotsTag);
        return tag;
    }

    public static ChunkLimitManager get(class_3218 level) {
        return (ChunkLimitManager)level.method_17983().method_17924(ChunkLimitManager::read, ChunkLimitManager::new, DATA_NAME);
    }
}

