/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.fabric.mixin;

import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import java.util.Optional;
import net.blay09.mods.littlejoys.handler.FishingSpotHandler;
import net.blay09.mods.littlejoys.handler.FishingSpotHolder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TideFishingHook.class})
public abstract class TideFishingHookMixin
extends class_1297
implements FishingSpotHolder {
    @Shadow(remap=false)
    private int nibble;
    @Shadow(remap=false)
    private int timeUntilLured;
    @Nullable
    private class_2338 littlejoys_fishingSpot;

    public TideFishingHookMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"catchingFish"}, at={@At(value="HEAD")}, remap=false)
    private void catchingFish(class_2338 pos, CallbackInfo ci) {
        try {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                TideFishingHookMixin fishingSpotHolder = this;
                if (fishingSpotHolder.getFishingSpot().isEmpty() && this.timeUntilLured > 40) {
                    FishingSpotHandler.findFishingSpot(serverLevel, pos).ifPresent(fishingSpotPos -> {
                        fishingSpotHolder.setFishingSpot((class_2338)fishingSpotPos);
                        int configuredTimeUntilLured = FishingSpotHandler.claimFishingSpot(serverLevel, fishingSpotPos);
                        if (configuredTimeUntilLured >= 0) {
                            this.timeUntilLured = Math.max(1, configuredTimeUntilLured);
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("LittleJoys crashed during catchingFish hook", e);
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/player/Player;)I"}, at={@At(value="RETURN")})
    private void retrieve(class_1799 itemStack, class_3218 level, class_1657 player, CallbackInfoReturnable<Integer> ci) {
        try {
            TideFishingHookMixin fishingSpotHolder = this;
            Optional<class_2338> fishingSpot = fishingSpotHolder.getFishingSpot();
            if (fishingSpot.isPresent() && this.nibble > 0) {
                FishingSpotHandler.consumeFishingSpot(player, level, fishingSpot.get());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("LittleJoys crashed during retrieve hook", e);
        }
    }

    @Override
    public Optional<class_2338> getFishingSpot() {
        return Optional.ofNullable(this.littlejoys_fishingSpot);
    }

    @Override
    public void setFishingSpot(class_2338 fishingSpot) {
        this.littlejoys_fishingSpot = fishingSpot;
    }

    @Override
    public class_1657 littlejoys$getPlayerOwner() {
        return ((TideFishingHook)this).getPlayerOwner();
    }
}

