/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.util.ItemStackHelper;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class InventoryUtil {
    public static class_1277 buildInventory(List<class_1799> list) {
        class_1277 inventory = new class_1277(list.size());
        for (int i = 0; i < list.size(); ++i) {
            inventory.method_5447(i, list.get(i).method_7972());
        }
        return inventory;
    }

    public static class_1277 buildInventory(class_1799 stack) {
        class_1277 inventory = new class_1277(1);
        inventory.method_5447(0, stack);
        return inventory;
    }

    public static class_1277 copyInventory(class_1263 inventory) {
        class_1277 copy = new class_1277(inventory.method_5439());
        for (int i = 0; i < inventory.method_5439(); ++i) {
            copy.method_5447(i, inventory.method_5438(i).method_7972());
        }
        return copy;
    }

    public static class_2371<class_1799> buildList(class_1263 inventory) {
        class_2371 list = class_2371.method_10213((int)inventory.method_5439(), (Object)class_1799.field_8037);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            list.set(i, (Object)inventory.method_5438(i).method_7972());
        }
        return list;
    }

    public static List<class_1799> copyList(List<class_1799> list) {
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        for (class_1799 stack : list) {
            result.add(stack.method_7972());
        }
        return result;
    }

    public static int GetItemCount(class_1263 inventory, class_1792 item) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != item) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static int GetItemCount(class_1263 inventory, class_1799 item) {
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static boolean RemoveItemCount(class_1263 inventory, class_1792 item, int count) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7909() != item) continue;
            if (stack.method_7947() > count) {
                stack.method_7934(count);
                return true;
            }
            count -= stack.method_7947();
            inventory.method_5447(i, class_1799.field_8037);
        }
        return count <= 0;
    }

    public static boolean RemoveItemCount(class_1263 inventory, class_1799 item) {
        if (InventoryUtil.GetItemCount(inventory, item) < item.method_7947()) {
            return false;
        }
        int count = item.method_7947();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.method_7947());
            count -= amountToTake;
            if (amountToTake == stack.method_7947()) {
                inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            stack.method_7934(amountToTake);
        }
        return true;
    }

    public static int GetItemSpace(class_1263 container, class_1799 item) {
        return InventoryUtil.GetItemSpace(container, item, 0, container.method_5439());
    }

    public static int GetItemSpace(class_1263 container, class_1799 item, int startingIndex, int stopIndex) {
        int count = 0;
        for (int i = startingIndex; i < stopIndex && i < container.method_5439(); ++i) {
            class_1799 stack = container.method_5438(i);
            if (InventoryUtil.ItemMatches(item, stack)) {
                count += stack.method_7914() - stack.method_7947();
                continue;
            }
            if (!stack.method_7960()) continue;
            count += stack.method_7914();
        }
        return count;
    }

    public static int GetItemTagCount(class_1263 inventory, class_2960 itemTag, class_1792 ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.method_7909())) continue;
            count += stack.method_7947();
        }
        return count;
    }

    public static boolean RemoveItemTagCount(class_1263 inventory, class_2960 itemTag, int count, class_1792 ... blacklistItems) {
        if (InventoryUtil.GetItemTagCount(inventory, itemTag, blacklistItems) < count) {
            return false;
        }
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.method_7909())) continue;
            int amountToTake = MathUtil.clamp(count, 0, stack.method_7947());
            count -= amountToTake;
            if (amountToTake == stack.method_7947()) {
                inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            stack.method_7934(amountToTake);
        }
        return true;
    }

    public static boolean PutItemStack(class_1263 inventory, class_1799 stack) {
        int amountToPlace;
        class_1799 inventoryStack;
        int i;
        int amountToMerge = stack.method_7947();
        class_1792 mergeItem = stack.method_7909();
        ArrayList<Pair> mergeOrders = new ArrayList<Pair>();
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.method_7947() == inventoryStack.method_7914()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.method_7914() - inventoryStack.method_7947());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!inventoryStack.method_7960()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.method_7914());
            mergeOrders.add(new Pair((Object)i, (Object)amountToPlace));
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            return false;
        }
        mergeOrders.forEach(order -> {
            class_1799 itemStack = inventory.method_5438(((Integer)order.getFirst()).intValue());
            if (itemStack.method_7960()) {
                class_1799 newStack = new class_1799((class_1935)mergeItem, ((Integer)order.getSecond()).intValue());
                if (stack.method_7985()) {
                    newStack.method_7980(stack.method_7969().method_10553());
                }
                inventory.method_5447(((Integer)order.getFirst()).intValue(), newStack);
            } else {
                itemStack.method_7939(itemStack.method_7947() + (Integer)order.getSecond());
            }
        });
        return true;
    }

    public static class_1799 TryPutItemStack(class_1263 inventory, class_1799 stack) {
        int amountToPlace;
        class_1799 inventoryStack;
        int i;
        int amountToMerge = stack.method_7947();
        class_1792 mergeItem = stack.method_7909();
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.method_7947() >= inventoryStack.method_7914()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.method_7914() - inventoryStack.method_7947());
            inventoryStack.method_7933(amountToPlace);
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!inventoryStack.method_7960()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.method_7914());
            class_1799 newStack = new class_1799((class_1935)mergeItem, amountToPlace);
            if (stack.method_7985()) {
                newStack.method_7980(stack.method_7969().method_10553());
            }
            inventory.method_5447(i, newStack);
            amountToMerge -= amountToPlace;
        }
        if (amountToMerge > 0) {
            class_1799 leftovers = stack.method_7972();
            leftovers.method_7939(amountToMerge);
            return leftovers;
        }
        return class_1799.field_8037;
    }

    public static boolean CanPutItemStack(class_1263 inventory, class_1799 stack) {
        int amountToPlace;
        class_1799 inventoryStack;
        int i;
        if (stack.method_7960()) {
            return true;
        }
        int amountToMerge = stack.method_7947();
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!InventoryUtil.ItemMatches(stack, inventoryStack) || inventoryStack.method_7947() == inventoryStack.method_7914()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, inventoryStack.method_7914() - inventoryStack.method_7947());
            amountToMerge -= amountToPlace;
        }
        for (i = 0; i < inventory.method_5439() && amountToMerge > 0; ++i) {
            inventoryStack = inventory.method_5438(i);
            if (!inventoryStack.method_7960()) continue;
            amountToPlace = MathUtil.clamp(amountToMerge, 0, stack.method_7914());
            amountToMerge -= amountToPlace;
        }
        return amountToMerge <= 0;
    }

    public static boolean CanPutItemStacks(class_1263 inventory, class_1799 ... stacks) {
        return InventoryUtil.CanPutItemStacks(inventory, Lists.newArrayList((Object[])stacks));
    }

    public static boolean CanPutItemStacks(class_1263 inventory, List<class_1799> stacks) {
        int i;
        class_1277 copyInventory = new class_1277(inventory.method_5439());
        for (i = 0; i < inventory.method_5439(); ++i) {
            copyInventory.method_5447(i, inventory.method_5438(i).method_7972());
        }
        for (i = 0; i < stacks.size(); ++i) {
            if (InventoryUtil.PutItemStack((class_1263)copyInventory, stacks.get(i))) continue;
            return false;
        }
        return true;
    }

    public static void MergeStacks(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            int amountWanted;
            class_1799 thisStack = inventory.method_5438(i);
            if (thisStack.method_7960() || (amountWanted = thisStack.method_7914() - thisStack.method_7947()) <= 0) continue;
            for (int j = i + 1; j < inventory.method_5439(); ++j) {
                class_1799 nextStack = inventory.method_5438(j);
                if (nextStack.method_7960() || nextStack.method_7909() != thisStack.method_7909() || !ItemStackHelper.TagEquals(thisStack, nextStack)) continue;
                while (amountWanted > 0 && !nextStack.method_7960()) {
                    nextStack.method_7939(nextStack.method_7947() - 1);
                    thisStack.method_7939(thisStack.method_7947() + 1);
                    --amountWanted;
                }
            }
        }
    }

    public static class_1277 loadAllItems(String key, class_2487 compound, int inventorySize) {
        class_2371 tempInventory = class_2371.method_10213((int)inventorySize, (Object)class_1799.field_8037);
        ItemStackHelper.loadAllItems(key, compound, (class_2371<class_1799>)tempInventory);
        return InventoryUtil.buildInventory((List<class_1799>)tempInventory);
    }

    public static void saveAllItems(String key, class_2487 compound, class_1263 inventory) {
        ItemStackHelper.saveAllItems(key, compound, InventoryUtil.buildList(inventory));
    }

    public static void dumpContents(class_1937 level, class_2338 pos, class_1263 inventory) {
        if (level.field_9236) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            InventoryUtil.dumpContents(level, pos, inventory.method_5438(i));
        }
    }

    public static void dumpContents(class_1937 level, class_2338 pos, List<class_1799> inventory) {
        if (level.field_9236) {
            return;
        }
        for (int i = 0; i < inventory.size(); ++i) {
            InventoryUtil.dumpContents(level, pos, inventory.get(i));
        }
    }

    public static void dumpContents(class_1937 level, class_2338 pos, class_1799 stack) {
        if (level.field_9236) {
            return;
        }
        if (!stack.method_7960()) {
            class_1542 entity = new class_1542(level, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
            level.method_8649((class_1297)entity);
        }
    }

    public static List<class_1799> combineQueryItems(class_1799 ... items) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        for (class_1799 item : items) {
            boolean addNew = true;
            for (int i = 0; i < itemList.size() && addNew; ++i) {
                if (!InventoryUtil.ItemMatches(item, (class_1799)itemList.get(i))) continue;
                ((class_1799)itemList.get(i)).method_7933(item.method_7947());
            }
            if (!addNew || item.method_7960()) continue;
            itemList.add(item.method_7972());
        }
        return itemList;
    }

    public static List<class_1799> combineQueryItems(List<class_1799> items) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        for (class_1799 item : items) {
            boolean addNew = true;
            for (int i = 0; i < itemList.size() && addNew; ++i) {
                if (!InventoryUtil.ItemMatches(item, (class_1799)itemList.get(i))) continue;
                ((class_1799)itemList.get(i)).method_7933(item.method_7947());
            }
            if (!addNew || item.method_7960()) continue;
            itemList.add(item.method_7972());
        }
        return itemList;
    }

    public static boolean ItemMatches(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7909() == stack2.method_7909()) {
            return ItemStackHelper.TagEquals(stack1, stack2);
        }
        return false;
    }

    public static boolean ItemHasTag(class_1799 item, class_2960 tag) {
        for (class_6862 itemTag : item.method_40133().toList()) {
            if (!itemTag.comp_327().equals((Object)tag)) continue;
            return true;
        }
        return false;
    }

    public static int safeGiveToPlayer(class_1661 inv, class_1799 stack) {
        int i = inv.method_7390(stack);
        if (i == -1) {
            i = inv.method_7376();
        }
        if (i >= 0) {
            class_1799 stackInSlot = inv.method_5438(i);
            int putCount = Math.min(stack.method_7947(), stackInSlot.method_7960() ? stack.method_7914() : stackInSlot.method_7914() - stackInSlot.method_7947());
            if (putCount > 0) {
                if (stackInSlot.method_7960()) {
                    stackInSlot = stack.method_7972();
                    stackInSlot.method_7939(putCount);
                } else {
                    stackInSlot.method_7933(putCount);
                }
                stack.method_7934(putCount);
                inv.method_5447(i, stackInSlot);
                inv.method_5431();
            }
            return putCount;
        }
        return 0;
    }

    public static void GiveToPlayer(class_1657 player, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        player.method_31548().method_7398(stack);
    }

    public static void GiveToPlayer(class_1657 player, List<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            InventoryUtil.GiveToPlayer(player, stack);
        }
    }
}

