/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.server.messages.bank;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.client.messages.bank.SMessageBankTransferResponse;
import io.github.lightman314.lightmanscurrency.network.server.ClientToServerPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class CMessageBankTransferPlayer
extends ClientToServerPacket {
    public static final class_2960 PACKET_ID = new class_2960("lightmanscurrency", "bank_transfer_player");
    private final String playerName;
    private final CoinValue amount;

    public CMessageBankTransferPlayer(String playerName, CoinValue amount) {
        super(PACKET_ID);
        this.playerName = playerName;
        this.amount = amount;
    }

    @Override
    protected void encode(LazyPacketData.Builder dataBuilder) {
        dataBuilder.setString("player", this.playerName).setCoinValue("amount", this.amount);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, LazyPacketData data, PacketSender responseSender) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BankAccount.IBankAccountAdvancedMenu) {
            BankAccount.IBankAccountAdvancedMenu menu = (BankAccount.IBankAccountAdvancedMenu)class_17032;
            BankAccount.AccountReference destination = BankAccount.GenerateReference(false, PlayerReference.of(false, data.getString("player")));
            class_5250 response = BankAccount.TransferCoins(menu, data.getCoinValue("amount"), destination);
            new SMessageBankTransferResponse(response).sendTo(responseSender);
        }
    }
}

