/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.mixin;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1725;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1728.class})
public abstract class MerchantScreenHandlerMixin {
    @Unique
    private class_1728 self() {
        return (class_1728)this;
    }

    @Accessor(value="merchant")
    public abstract class_1915 getTrader();

    @Accessor(value="merchantInventory")
    public abstract class_1725 getTradeContainer();

    @Unique
    private class_1657 getPlayer() {
        class_1915 m = this.getTrader();
        if (m != null) {
            return m.method_8257();
        }
        return null;
    }

    @Inject(at={@At(value="HEAD")}, method={"switchTo"})
    private void tryMoveItemsEarly(int trade, CallbackInfo info) {
        try {
            class_1728 self = this.self();
            if (trade >= 0 && trade < self.method_17438().size()) {
                this.EjectMoneyIntoWallet(this.getPlayer(), false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"switchTo"})
    private void tryMoveItems(int trade, CallbackInfo info) {
        try {
            class_1914 offer;
            class_1725 tradeContainer;
            class_1728 self = this.self();
            if (trade >= 0 && trade < self.method_17438().size() && (tradeContainer = this.getTradeContainer()).method_5438(0).method_7960() && tradeContainer.method_5438(1).method_7960() && MoneyUtil.isCoin((offer = (class_1914)self.method_17438().get(trade)).method_19272(), false) && MerchantScreenHandlerMixin.isCoinOrEmpty(offer.method_8247())) {
                class_1799 coinA = offer.method_19272().method_7972();
                class_1799 coinB = offer.method_8247().method_7972();
                CoinValue tradeValue = MoneyUtil.getCoinValue((List<class_1799>)ImmutableList.of((Object)coinA, (Object)coinB));
                LightmansCurrency.LogDebug("Coin Value of the selected trade is " + tradeValue.getString());
                class_1657 player = this.getPlayer();
                if (player == null) {
                    return;
                }
                WalletHandler walletHandler = WalletHandler.getWallet(player);
                if (walletHandler.getWallet().method_7960()) {
                    return;
                }
                CoinValue availableFunds = MoneyUtil.getCoinValue(WalletItem.getWalletInventory(walletHandler.getWallet()));
                CoinValue fundsToExtract = CoinValue.EMPTY;
                int coinACount = coinA.method_7947();
                int coinBCount = coinB.method_7960() ? 0 : coinB.method_7947();
                int coinAMaxCount = coinA.method_7914();
                int coinBMaxCount = coinB.method_7960() ? 0 : coinB.method_7914();
                int coinToAddA = 0;
                int coinToAddB = 0;
                boolean keepLooping = true;
                while (keepLooping) {
                    int tempC2AA = coinAMaxCount > coinToAddA ? MathUtil.clamp(coinToAddA + coinACount, 0, coinAMaxCount) : coinToAddA;
                    int tempC2AB = coinBMaxCount > coinToAddB ? MathUtil.clamp(coinToAddB + coinBCount, 0, coinBMaxCount) : coinToAddB;
                    coinA.method_7939(tempC2AA);
                    coinB.method_7939(tempC2AB);
                    CoinValue thisValue = MoneyUtil.getCoinValue((List<class_1799>)ImmutableList.of((Object)coinA, (Object)coinB));
                    if (availableFunds.getRawValue() < thisValue.getRawValue()) {
                        keepLooping = false;
                        continue;
                    }
                    fundsToExtract = thisValue;
                    coinToAddA = tempC2AA;
                    coinToAddB = tempC2AB;
                    if (coinToAddA < coinAMaxCount || coinToAddB < coinBMaxCount) continue;
                    keepLooping = false;
                }
                if ((coinToAddA > 0 || coinToAddB > 0) && fundsToExtract.hasAny()) {
                    coinA.method_7939(coinToAddA);
                    coinB.method_7939(coinToAddB);
                    if (MoneyUtil.ProcessPayment(null, player, fundsToExtract)) {
                        tradeContainer.method_5447(0, coinA.method_7972());
                        tradeContainer.method_5447(1, coinB.method_7972());
                        LightmansCurrency.LogDebug("Moved " + fundsToExtract.getString() + " worth of coins into the Merchant Menu!");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onClosed"})
    private void removed(class_1657 player, CallbackInfo info) {
        if (this.isPlayerAliveAndValid(player)) {
            this.EjectMoneyIntoWallet(player, true);
        }
    }

    @Unique
    private boolean isPlayerAliveAndValid(class_1657 player) {
        if (player.method_5805()) {
            if (player instanceof class_3222) {
                class_3222 sp = (class_3222)player;
                return !sp.method_14239();
            }
            return true;
        }
        return false;
    }

    @Unique
    private void EjectMoneyIntoWallet(class_1657 player, boolean noUpdate) {
        class_1725 tradeContainer = this.getTradeContainer();
        class_1799 item = tradeContainer.method_5438(0);
        if (!item.method_7960() && MoneyUtil.isCoin(item, false)) {
            MoneyUtil.ProcessChange(null, player, MoneyUtil.getCoinValue(item));
            if (noUpdate) {
                tradeContainer.method_5441(0);
            } else {
                tradeContainer.method_5447(0, class_1799.field_8037);
            }
        }
        if (!(item = tradeContainer.method_5438(1)).method_7960() && MoneyUtil.isCoin(item, false)) {
            MoneyUtil.ProcessChange(null, player, MoneyUtil.getCoinValue(item));
            if (noUpdate) {
                tradeContainer.method_5441(1);
            } else {
                tradeContainer.method_5447(1, class_1799.field_8037);
            }
        }
    }

    @Unique
    private static boolean isCoinOrEmpty(class_1799 item) {
        return MoneyUtil.isCoin(item, false) || item.method_7960();
    }
}

