/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.fluid;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7923;

public class FluidStack
implements FluidVariant {
    public static final FluidStack EMPTY = new FluidStack(class_3612.field_15906, 0L);
    private final class_3611 fluid;
    private long quantity = 0L;
    private class_2487 nbt;

    public FluidStack(class_3611 fluid, long quantity) {
        this(fluid, quantity, null);
    }

    public FluidStack(class_3611 fluid, long quantity, class_2487 nbt) {
        this.fluid = fluid == null ? class_3612.field_15906 : fluid;
        this.quantity = Math.max(quantity, 0L);
        this.nbt = nbt;
    }

    public final class_3611 getFluid() {
        return this.fluid;
    }

    public final boolean isEmpty() {
        return this.fluid == class_3612.field_15906 || this.quantity <= 0L;
    }

    public long getAmount() {
        return this.quantity;
    }

    public void increment(long amount) {
        this.quantity += this.quantity;
    }

    public void decrement(long amounnt) {
        this.quantity -= this.quantity;
    }

    public boolean isBlank() {
        return this.isEmpty();
    }

    public class_3611 getObject() {
        return this.fluid;
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public class_2487 toNbt() {
        class_2487 compound = new class_2487();
        compound.method_10582("Fluid", class_7923.field_41173.method_10221((Object)this.fluid).toString());
        compound.method_10544("Quantity", Math.max(this.quantity, 0L));
        if (this.nbt != null) {
            compound.method_10566("Tag", (class_2520)this.nbt);
        }
        return compound;
    }

    public static FluidStack fromNbt(class_2487 compound) {
        FluidStack stack;
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(compound.method_10558("Fluid")));
        long quantity = compound.method_10537("Quantity");
        class_2487 nbt = null;
        if (compound.method_10573("Tag", 10)) {
            nbt = compound.method_10562("Tag");
        }
        return (stack = new FluidStack(fluid, quantity, nbt)).isEmpty() ? EMPTY : stack;
    }

    public void toPacket(class_2540 buffer) {
        buffer.writeBoolean(this.isEmpty());
        if (!this.isEmpty()) {
            buffer.method_10814(class_7923.field_41173.method_10221((Object)this.fluid).toString());
            buffer.writeLong(Math.max(this.quantity, 0L));
            buffer.writeBoolean(this.nbt != null);
            if (this.nbt != null) {
                buffer.method_10794(this.nbt);
            }
        }
    }

    public static FluidStack fromPacket(class_2540 buffer) {
        if (buffer.readBoolean()) {
            return EMPTY;
        }
        class_3611 fluid = (class_3611)class_7923.field_41173.method_10223(new class_2960(buffer.method_19772()));
        long quantity = buffer.readLong();
        class_2487 nbt = buffer.readBoolean() ? buffer.method_30617() : null;
        FluidStack stack = new FluidStack(fluid, quantity, nbt);
        return stack.isEmpty() ? EMPTY : stack;
    }

    public boolean matches(FluidStack other) {
        return other.fluid == this.fluid && this.nbtMatches(other.nbt);
    }

    public class_2487 getOrCreateNbt() {
        if (this.nbt == null) {
            this.nbt = new class_2487();
        }
        return this.nbt;
    }
}

