/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.SpeedUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.ItemCapacityUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class UpgradeType {
    private static final Map<class_2960, UpgradeType> UPGRADE_TYPE_REGISTRY = new HashMap<class_2960, UpgradeType>();
    public static final ItemCapacityUpgrade ITEM_CAPACITY = UpgradeType.register(new class_2960("lightmanscurrency", "item_capacity"), new ItemCapacityUpgrade());
    public static final SpeedUpgrade SPEED = UpgradeType.register(new class_2960("lightmanscurrency", "speed"), new SpeedUpgrade());
    public static final Simple NETWORK = UpgradeType.register(new class_2960("lightmanscurrency", "trader_network"), new Simple(new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.upgrade.network")}));
    public static final Simple HOPPER = UpgradeType.register(new class_2960("lightmanscurrency", "hopper"), new Simple(new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.upgrade.hopper")}));
    private class_2960 type;

    protected abstract List<String> getDataTags();

    protected abstract Object defaultTagValue(String var1);

    public List<class_2561> getTooltip(UpgradeData data) {
        return new ArrayList<class_2561>();
    }

    public final UpgradeData getDefaultData() {
        return new UpgradeData(this);
    }

    public UpgradeType setRegistryName(class_2960 name) {
        this.type = name;
        return this;
    }

    public class_2960 getRegistryName() {
        return this.type;
    }

    public Class<UpgradeType> getRegistryType() {
        return UpgradeType.class;
    }

    public static <T extends UpgradeType> T register(class_2960 type, T upgradeType) {
        upgradeType.setRegistryName(type);
        UPGRADE_TYPE_REGISTRY.put(type, upgradeType);
        return upgradeType;
    }

    public static boolean hasUpgrade(UpgradeType type, class_1263 upgradeContainer) {
        for (int i = 0; i < upgradeContainer.method_5439(); ++i) {
            UpgradeItem upgradeItem;
            class_1799 stack = upgradeContainer.method_5438(i);
            if (!(stack.method_7909() instanceof UpgradeItem) || (upgradeItem = (UpgradeItem)stack.method_7909()).getUpgradeType() != type) continue;
            return true;
        }
        return false;
    }

    public static class UpgradeData {
        private final Map<String, Object> data = Maps.newHashMap();

        public Set<String> getKeys() {
            return this.data.keySet();
        }

        public boolean hasKey(String tag) {
            return this.getKeys().contains(tag);
        }

        public UpgradeData(UpgradeType upgrade) {
            for (String tag : upgrade.getDataTags()) {
                Object defaultValue = upgrade.defaultTagValue(tag);
                this.data.put(tag, defaultValue);
            }
        }

        public void setValue(String tag, Object value) {
            if (this.data.containsKey(tag)) {
                this.data.put(tag, value);
            }
        }

        public Object getValue(String tag) {
            if (this.data.containsKey(tag)) {
                return this.data.get(tag);
            }
            return null;
        }

        public int getIntValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return 0;
        }

        public float getFloatValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof Float) {
                return ((Float)value).floatValue();
            }
            return 0.0f;
        }

        public String getStringValue(String tag) {
            Object value = this.getValue(tag);
            if (value instanceof String) {
                return (String)value;
            }
            return "";
        }

        public void read(class_2487 compound) {
            compound.method_10541().forEach(key -> {
                if (this.hasKey((String)key)) {
                    if (compound.method_10573(key, 3)) {
                        this.setValue((String)key, compound.method_10550(key));
                    } else if (compound.method_10573(key, 5)) {
                        this.setValue((String)key, Float.valueOf(compound.method_10583(key)));
                    } else if (compound.method_10573(key, 8)) {
                        this.setValue((String)key, compound.method_10558(key));
                    }
                }
            });
        }

        public class_2487 writeToNBT() {
            return this.writeToNBT(null);
        }

        public class_2487 writeToNBT(UpgradeType source) {
            Map<String, Object> modifiedEntries = source == null ? this.data : UpgradeData.getModifiedEntries(this, source);
            class_2487 compound = new class_2487();
            modifiedEntries.forEach((key, value) -> {
                if (value instanceof Integer) {
                    compound.method_10569(key, ((Integer)value).intValue());
                } else if (value instanceof Float) {
                    compound.method_10548(key, ((Float)value).floatValue());
                } else if (value instanceof String) {
                    compound.method_10582(key, (String)value);
                }
            });
            return compound;
        }

        public static Map<String, Object> getModifiedEntries(UpgradeData queryData, UpgradeType source) {
            HashMap modifiedEntries = Maps.newHashMap();
            source.getDefaultData().data.forEach((key, value) -> {
                if (queryData.data.containsKey(key) && !Objects.equal((Object)queryData.data.get(key), (Object)value)) {
                    modifiedEntries.put(key, value);
                }
            });
            return modifiedEntries;
        }
    }

    public static class Simple
    extends UpgradeType {
        private final List<class_2561> tooltips;

        public Simple(class_2561 ... tooltips) {
            this.tooltips = Lists.newArrayList((Object[])tooltips);
        }

        @Override
        protected List<String> getDataTags() {
            return new ArrayList<String>();
        }

        @Override
        protected Object defaultTagValue(String tag) {
            return null;
        }

        @Override
        public List<class_2561> getTooltip(UpgradeData data) {
            return this.tooltips;
        }
    }

    public static interface IUpgradeItem {
        public UpgradeType getUpgradeType();

        public UpgradeData getDefaultUpgradeData();

        default public void onApplied(IUpgradeable target) {
        }
    }

    public static interface IUpgradeable {
        default public boolean allowUpgrade(UpgradeItem item) {
            return this.allowUpgrade(item.getUpgradeType());
        }

        public boolean allowUpgrade(UpgradeType var1);
    }
}

