/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.slot_machine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menu.SlotMachineMenu;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachinePriceTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachineStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.SlotMachineTradeNotification;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.trade_data.SlotMachineTrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotMachineTraderData
extends TraderData
implements TraderItemStorage.ITraderItemFilter {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "slot_machine_trader");
    private CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
    private List<class_1799> lastReward = new ArrayList<class_1799>();
    private final List<SlotMachineEntry> entries = Lists.newArrayList((Object[])new SlotMachineEntry[]{SlotMachineEntry.create()});
    private boolean entriesChanged = false;
    private final TraderItemStorage storage = new TraderItemStorage(this);
    private final ImmutableList<SlotMachineTrade> trade = ImmutableList.of((Object)new SlotMachineTrade(this));

    public final CoinValue getPrice() {
        return this.price.copy();
    }

    public void setPrice(CoinValue newValue) {
        this.price = newValue.copy();
        this.markPriceDirty();
    }

    public final boolean isPriceValid() {
        return this.price.isValid();
    }

    public List<class_1799> getLastRewards() {
        return ImmutableList.copyOf(this.lastReward);
    }

    public final List<SlotMachineEntry> getAllEntries() {
        return new ArrayList<SlotMachineEntry>(this.entries);
    }

    public final List<SlotMachineEntry> getValidEntries() {
        return this.entries.stream().filter(SlotMachineEntry::isValid).toList();
    }

    public boolean areEntriesChanged() {
        return this.entriesChanged;
    }

    public void clearEntriesChangedCache() {
        this.entriesChanged = false;
    }

    public void addEntry() {
        if (this.entries.size() >= 32) {
            return;
        }
        this.entries.add(SlotMachineEntry.create());
        this.markEntriesDirty();
    }

    public void removeEntry(int entryIndex) {
        if (entryIndex < 0 || entryIndex >= this.entries.size()) {
            return;
        }
        this.entries.remove(entryIndex);
        this.markEntriesDirty();
    }

    public final int getTotalWeight() {
        int weight = 0;
        for (SlotMachineEntry entry : this.getValidEntries()) {
            weight += entry.getWeight();
        }
        return weight;
    }

    @Nullable
    public final SlotMachineEntry getRandomizedEntry(TradeContext context) {
        if (!context.hasPlayer()) {
            return this.getRandomizedEntry(new Random().nextInt(this.getTotalWeight()) + 1);
        }
        class_1937 level = context.getPlayer().method_37908();
        return this.getRandomizedEntry(level.field_9229.method_43048(this.getTotalWeight()) + 1);
    }

    private SlotMachineEntry getRandomizedEntry(int rand) {
        for (SlotMachineEntry entry : this.getValidEntries()) {
            if ((rand -= entry.getWeight()) > 0) continue;
            return entry;
        }
        return null;
    }

    public final List<class_2561> getSlotMachineInfo() {
        ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
        if (!this.hasValidTrade()) {
            tooltips.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.slot_machine.undefined", new Object[0]).method_27692(class_124.field_1061));
            return tooltips;
        }
        if (!this.hasStock()) {
            tooltips.add((class_2561)EasyText.translatable("tooltip.lightmanscurrency.outofstock", new Object[0]).method_27692(class_124.field_1061));
        }
        return tooltips;
    }

    public String getOdds(int weight) {
        DecimalFormat df = new DecimalFormat();
        double odds = (double)weight / (double)this.getTotalWeight() * 100.0;
        df.setMaximumFractionDigits(odds < 1.0 ? 2 : 0);
        return df.format(odds);
    }

    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    public SlotMachineTraderData() {
        super(TYPE);
    }

    public SlotMachineTraderData(@NotNull class_1937 level, @NotNull class_2338 pos) {
        super(TYPE, level, pos);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER_ALT;
    }

    @Override
    protected boolean allowAdditionalUpgradeType(UpgradeType type) {
        return type == UpgradeType.ITEM_CAPACITY;
    }

    @Override
    public int getTradeCount() {
        return 1;
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return this.hasStock() ? 1 : 0;
    }

    public boolean hasStock() {
        if (!this.hasValidTrade()) {
            return false;
        }
        if (this.isCreative()) {
            return true;
        }
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isValid() || entry.hasStock(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasValidTrade() {
        return this.entries.stream().anyMatch(SlotMachineEntry::isValid) && this.isPriceValid();
    }

    @Override
    protected void saveTrades(class_2487 compound) {
    }

    @Override
    protected ExtendedScreenHandlerFactory getTraderMenuProvider() {
        return new SlotMachineMenuProvider(this.getID());
    }

    public final void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    public final void markLastRewardDirty() {
        this.markDirty(this::saveLastRewards);
    }

    public final void markEntriesDirty() {
        this.markDirty(this::saveEntries);
    }

    public final void markPriceDirty() {
        this.markDirty(this::savePrice);
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        this.saveStorage(compound);
        this.saveLastRewards(compound);
        this.saveEntries(compound);
        this.savePrice(compound);
    }

    protected final void saveStorage(class_2487 compound) {
        this.storage.save(compound, "Storage");
    }

    protected final void saveLastRewards(class_2487 compound) {
        class_2499 itemList = new class_2499();
        for (class_1799 reward : this.lastReward) {
            if (reward.method_7960()) continue;
            itemList.add((Object)reward.method_7953(new class_2487()));
        }
        compound.method_10566("LastReward", (class_2520)itemList);
    }

    protected final void saveEntries(class_2487 compound) {
        class_2499 list = new class_2499();
        for (SlotMachineEntry entry : this.entries) {
            list.add((Object)entry.save());
        }
        compound.method_10566("Entries", (class_2520)list);
    }

    protected final void savePrice(class_2487 compound) {
        this.price.save(compound, "Price");
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        int i;
        if (compound.method_10545("Storage")) {
            this.storage.load(compound, "Storage");
        }
        if (compound.method_10545("LastReward")) {
            this.lastReward.clear();
            class_2499 itemList = compound.method_10554("LastReward", 10);
            for (i = 0; i < itemList.size(); ++i) {
                class_1799 stack = class_1799.method_7915((class_2487)itemList.method_10602(i));
                if (stack.method_7960()) continue;
                this.lastReward.add(stack);
            }
        }
        if (compound.method_10545("Entries")) {
            this.entries.clear();
            class_2499 list = compound.method_10554("Entries", 10);
            for (i = 0; i < list.size(); ++i) {
                this.entries.add(SlotMachineEntry.load(list.method_10602(i)));
            }
            this.entriesChanged = true;
        }
        if (compound.method_10545("Price")) {
            this.price.load(compound, "Price");
        }
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json) {
        json.add("Price", this.price.toJson());
        JsonArray entryList = new JsonArray();
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isValid()) continue;
            entryList.add((JsonElement)entry.toJson());
        }
        json.add("Entries", (JsonElement)entryList);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json) throws Exception {
        if (!json.has("Price")) {
            throw new JsonSyntaxException("Expected a 'Price' entry!");
        }
        this.price = CoinValue.Parse(json.get("Price"));
        this.entries.clear();
        JsonArray entryList = class_3518.method_15261((JsonObject)json, (String)"Entries");
        for (int i = 0; i < entryList.size(); ++i) {
            try {
                this.entries.add(SlotMachineEntry.parse(class_3518.method_15295((JsonElement)entryList.get(i), (String)("Entries[" + i + "]"))));
                continue;
            }
            catch (JsonSyntaxException | class_151 t) {
                LightmansCurrency.LogError("Error parsing Slot Machine Trader Entry #" + (i + 1), t);
            }
        }
        if (this.entries.size() == 0) {
            throw new JsonSyntaxException("Slot Machine Trader had no valid Entries!");
        }
    }

    @Override
    protected void saveAdditionalPersistentData(class_2487 compound) {
        this.saveLastRewards(compound);
    }

    @Override
    protected void loadAdditionalPersistentData(class_2487 compound) {
        if (compound.method_10545("LastReward")) {
            this.lastReward = new ArrayList<class_1799>();
            class_2499 itemList = compound.method_10554("LastReward", 10);
            for (int i = 0; i < itemList.size(); ++i) {
                class_1799 stack = class_1799.method_7915((class_2487)itemList.method_10602(i));
                if (stack.method_7960()) continue;
                this.lastReward.add(stack);
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<class_1799> results) {
        results.addAll(this.storage.getSplitContents());
    }

    public List<SlotMachineTrade> getTradeData() {
        return this.trade;
    }

    @Nullable
    public SlotMachineTrade getTrade(int tradeIndex) {
        return (SlotMachineTrade)this.trade.get(0);
    }

    @Override
    public void addTrade(class_1657 requestor) {
    }

    @Override
    public void removeTrade(class_1657 requestor) {
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!this.hasValidTrade()) {
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        SlotMachineTrade trade = (SlotMachineTrade)this.trade.get(0);
        if (trade == null) {
            trade = new SlotMachineTrade(this);
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (!this.hasStock()) {
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        SlotMachineEntry loot = this.getRandomizedEntry(context);
        if (loot == null) {
            LightmansCurrency.LogError("Slot Machine encountered an error randomizing the loot.");
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (!loot.CanGiveToCustomer(context)) {
            return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
        }
        if (context.getPayment(price)) {
            if (!loot.GiveToCustomer(this, context)) {
                context.givePayment(price);
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.lastReward = loot.getDisplayItems();
            this.markLastRewardDirty();
            if (!this.isCreative()) {
                this.addStoredMoney(price);
                if (!this.hasStock()) {
                    this.pushNotification(() -> new OutOfStockNotification(this.getNotificationCategory(), -1));
                }
            }
            this.pushNotification(SlotMachineTradeNotification.create(loot, price, context.getPlayerReference(), this.getNotificationCategory()));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    protected void addSettingsTabs(List<SettingsTab> tabs) {
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(0, new SlotMachineEntryTab(menu));
        menu.setTab(1, new SlotMachinePriceTab(menu));
        menu.setTab(2, new SlotMachineStorageTab(menu));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void addPermissionOptions(List<PermissionOption> options) {
    }

    @Override
    public void addInteractionSlots(List<InteractionSlotData> interactionSlots) {
    }

    @Override
    public boolean isItemRelevant(class_1799 item) {
        for (SlotMachineEntry entry : this.entries) {
            if (!entry.isItemRelevant(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().method_5439(); ++i) {
            UpgradeItem upgradeItem;
            class_1799 stack = this.getUpgrades().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)class_17922) || !(upgradeItem.getUpgradeType() instanceof CapacityUpgrade)) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    private record SlotMachineMenuProvider(long traderID) implements ExtendedScreenHandlerFactory
    {
        public class_1703 createMenu(int windowID, class_1661 inventory, class_1657 player) {
            return new SlotMachineMenu(windowID, inventory, this.traderID);
        }

        public class_2561 method_5476() {
            return EasyText.empty();
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.writeLong(this.traderID);
        }
    }
}

