/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;

public class PlayerBlacklist
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "blacklist");
    List<PlayerReference> bannedPlayers = new ArrayList<PlayerReference>();

    public PlayerBlacklist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isBlacklisted(event.getPlayerReference())) {
            event.addDenial(class_2561.method_43471((String)"traderule.lightmanscurrency.blacklist.denial"));
        }
    }

    public boolean isBlacklisted(PlayerReference player) {
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            if (!bannedPlayer.is(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        class_2499 playerNameList = new class_2499();
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            playerNameList.add((Object)bannedPlayer.save());
        }
        compound.method_10566("BannedPlayers", (class_2520)playerNameList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        JsonArray blacklist = new JsonArray();
        for (PlayerReference bannedPlayer : this.bannedPlayers) {
            blacklist.add((JsonElement)bannedPlayer.saveAsJson());
        }
        json.add("BannedPlayers", (JsonElement)blacklist);
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("BannedPlayers", 9)) {
            this.bannedPlayers.clear();
            class_2499 playerList = compound.method_10554("BannedPlayers", 10);
            for (int i = 0; i < playerList.size(); ++i) {
                PlayerReference reference = PlayerReference.load(playerList.method_10602(i));
                if (reference == null) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public void handleUpdateMessage(class_2487 updateInfo) {
        boolean add = updateInfo.method_10577("Add");
        String name = updateInfo.method_10558("Name");
        PlayerReference player = PlayerReference.of(false, name);
        if (player == null) {
            return;
        }
        if (add && !this.isBlacklisted(player)) {
            this.bannedPlayers.add(player);
        } else if (!add && this.isBlacklisted(player)) {
            PlayerReference.removeFromList(this.bannedPlayers, player);
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("BannedPlayers")) {
            this.bannedPlayers.clear();
            JsonArray blacklist = json.get("BannedPlayers").getAsJsonArray();
            for (int i = 0; i < blacklist.size(); ++i) {
                PlayerReference reference = PlayerReference.load((JsonElement)blacklist.get(i).getAsJsonObject());
                if (reference == null || this.isBlacklisted(reference)) continue;
                this.bannedPlayers.add(reference);
            }
        }
    }

    @Override
    public class_2487 savePersistentData() {
        return null;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_BLACKLIST;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_342 nameInput;
        class_4185 buttonAddPlayer;
        class_4185 buttonRemovePlayer;
        ScrollTextDisplay playerDisplay;

        protected final PlayerBlacklist getBlacklistRule() {
            if (this.getRuleRaw() instanceof PlayerBlacklist) {
                return (PlayerBlacklist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            class_327 class_3272 = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new class_342(class_3272, n, n2, 176 - 20, 20, (class_2561)class_2561.method_43473()));
            this.buttonAddPlayer = this.addCustomRenderable(new VanillaButton(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.blacklist.add"), this::PressBlacklistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new VanillaButton(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.blacklist.remove"), this::PressForgiveButton));
            int n4 = this.screen.guiLeft() + 7;
            int n5 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            this.playerDisplay = this.addCustomRenderable(new ScrollTextDisplay(n4, n5, 176 - 14, 114, this.screen.getFont(), (Supplier<List<? extends class_2561>>)((Supplier)this::getBlacklistedPlayers)));
            this.playerDisplay.setColumnCount(2);
        }

        private List<class_2561> getBlacklistedPlayers() {
            ArrayList playerList = Lists.newArrayList();
            if (this.getBlacklistRule() == null) {
                return playerList;
            }
            for (PlayerReference player : this.getBlacklistRule().bannedPlayers) {
                playerList.add(player.getNameComponent(true));
            }
            return playerList;
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.playerDisplay);
        }

        void PressBlacklistButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", true);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }

        void PressForgiveButton(class_4185 button) {
            String name = this.nameInput.method_1882();
            if (!name.isBlank()) {
                this.nameInput.method_1852("");
                class_2487 updateInfo = new class_2487();
                updateInfo.method_10556("Add", false);
                updateInfo.method_10582("Name", name);
                this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
            }
        }
    }
}

