/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class FreeSample
extends TradeRule {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "free_sample");
    List<UUID> memory = new ArrayList<UUID>();

    public void resetMemory() {
        this.memory.clear();
    }

    public FreeSample() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.giveDiscount(event)) {
            event.addHelpful(class_2561.method_43471((String)"traderule.lightmanscurrency.free_sample.alert"));
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.giveDiscount(event)) {
            event.applyCostMultiplier(0.0);
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.giveDiscount(event)) {
            this.addToMemory(event.getPlayerReference().id);
            event.markDirty();
        }
    }

    private boolean giveDiscount(TradeEvent event) {
        return this.giveDiscount(event.getPlayerReference().id) && event.getTrade().getTradeDirection() != TradeData.TradeDirection.PURCHASE;
    }

    private void addToMemory(UUID playerID) {
        if (!this.memory.contains(playerID)) {
            this.memory.add(playerID);
        }
    }

    public boolean giveDiscount(UUID playerID) {
        return !this.givenFreeSample(playerID);
    }

    private boolean givenFreeSample(UUID playerID) {
        return this.memory.contains(playerID);
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        class_2499 memoryList = new class_2499();
        for (UUID entry : this.memory) {
            class_2487 tag = new class_2487();
            tag.method_25927("ID", entry);
            memoryList.add((Object)tag);
        }
        compound.method_10566("Memory", (class_2520)memoryList);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        return json;
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        if (compound.method_10573("Memory", 9)) {
            this.memory.clear();
            class_2499 memoryList = compound.method_10554("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                class_2487 tag = memoryList.method_10602(i);
                if (tag.method_10545("ID")) {
                    this.memory.add(tag.method_25926("ID"));
                    continue;
                }
                if (!tag.method_10545("id")) continue;
                this.memory.add(tag.method_25926("id"));
            }
        }
    }

    @Override
    public class_2487 savePersistentData() {
        class_2487 data = new class_2487();
        this.saveAdditional(data);
        return data;
    }

    @Override
    public void loadPersistentData(class_2487 data) {
        this.loadAdditional(data);
    }

    @Override
    public void loadFromJson(JsonObject json) {
    }

    @Override
    protected void handleUpdateMessage(class_2487 updateInfo) {
        if (updateInfo.method_10545("ClearData")) {
            this.resetMemory();
        }
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_FREE_SAMPLE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @Environment(value=EnvType.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        class_4185 buttonClearMemory;

        private FreeSample getRule() {
            if (this.getRuleRaw() instanceof FreeSample) {
                return (FreeSample)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new VanillaButton(n, n2, 176 - 20, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.free_sample.reset"), this::PressClearMemoryButton));
        }

        @Override
        public void renderTab(class_332 gui, int mouseX, int mouseY, float partialTicks) {
            if (this.buttonClearMemory.method_25405((double)mouseX, (double)mouseY)) {
                gui.method_51438(this.screen.getFont(), (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.free_sample.reset.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.buttonClearMemory);
        }

        @Override
        public void onScreenTick() {
        }

        void PressClearMemoryButton(class_4185 button) {
            this.getRule().memory.clear();
            class_2487 updateInfo = new class_2487();
            updateInfo.method_10556("ClearData", true);
            this.screen.sendUpdateMessage(this.getRuleRaw(), updateInfo);
        }
    }
}

