/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menu.slots.ticket.TicketSlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public static TicketKioskRestriction INSTANCE = new TicketKioskRestriction();

    private TicketKioskRestriction() {
    }

    @Override
    public class_1799 modifySellItem(class_1799 sellItem, String customName, ItemTradeData trade) {
        if (sellItem.method_7909() instanceof TicketItem && !customName.isBlank()) {
            sellItem.method_7977((class_2561)class_2561.method_43470((String)customName));
        }
        return sellItem;
    }

    @Override
    public boolean allowSellItem(class_1799 itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && itemStack.method_7909() != ModItems.TICKET;
    }

    @Override
    public class_1799 filterSellItem(class_1799 itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return TicketItem.CreateTicket(TicketItem.GetTicketID(itemStack), 1);
        }
        if (InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && itemStack.method_7909() != ModItems.TICKET) {
            return itemStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean allowItemSelectItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG) && item != ModItems.TICKET && item != ModItems.TICKET_MASTER;
    }

    @Override
    public boolean allowExtraItemInStorage(class_1799 itemStack) {
        return InventoryUtil.ItemHasTag(itemStack, TicketItem.TICKET_MATERIAL_TAG);
    }

    @Override
    public int getSaleStock(TraderItemStorage traderStorage, class_1799 ... sellItemList) {
        int ticketCount = 0;
        boolean foundTicket = false;
        int minStock = Integer.MAX_VALUE;
        for (class_1799 sellItem : sellItemList) {
            ticketCount += sellItem.method_7947();
            if (sellItem.method_7909() == ModItems.TICKET) {
                foundTicket = true;
                continue;
            }
            minStock = Math.min(this.getItemStock(sellItem, traderStorage), minStock);
        }
        if (foundTicket && ticketCount > 0) {
            minStock = Math.min(this.getTicketStock(ticketCount, traderStorage), minStock);
        }
        return minStock;
    }

    protected final int getTicketStock(int ticketCount, TraderItemStorage traderStorage) {
        return traderStorage.getItemTagCount(TicketItem.TICKET_MATERIAL_TAG, ModItems.TICKET_MASTER) / ticketCount;
    }

    @Override
    public void removeItemsFromStorage(TraderItemStorage traderStorage, class_1799 ... sellItemList) {
        ArrayList<class_1799> tickets = new ArrayList<class_1799>();
        ArrayList<class_1799> ignoreIfPossible = new ArrayList<class_1799>();
        for (class_1799 sellItem : sellItemList) {
            if (sellItem.method_7909() == ModItems.TICKET) {
                tickets.add(sellItem);
                continue;
            }
            this.removeFromStorage(sellItem, traderStorage);
            ignoreIfPossible.add(sellItem);
        }
        int printCount = 0;
        for (class_1799 ticketStack : tickets) {
            printCount += ticketStack.method_7947() - traderStorage.removeItem(ticketStack).method_7947();
        }
        if (printCount > 0) {
            traderStorage.removeItemTagCount(TicketItem.TICKET_MATERIAL_TAG, printCount, ignoreIfPossible, ModItems.TICKET_MASTER);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Pair<class_2960, class_2960> getEmptySlotBG() {
        return Pair.of((Object)class_1723.field_21668, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

