/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.IBarterTrade;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ItemTradeData
extends TradeData
implements IBarterTrade {
    public static final int MAX_CUSTOMNAME_LENGTH = 30;
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    class_1277 items = new class_1277(4);
    ItemTradeType tradeType = ItemTradeType.SALE;
    String customName1 = "";
    String customName2 = "";

    public ItemTradeData(boolean validateRules) {
        super(validateRules);
    }

    public static int MaxTradeTypeStringLength() {
        int length = 0;
        for (ItemTradeType value : ItemTradeType.values()) {
            int thisLength = value.name().length();
            if (thisLength <= length) continue;
            length = thisLength;
        }
        return length;
    }

    public class_1799 getSellItem(int index) {
        if (index >= 0 && index < 2) {
            return this.restriction.modifySellItem(this.items.method_5438(index).method_7972(), this.getCustomName(index), this);
        }
        return class_1799.field_8037;
    }

    public class_1799 getBarterItem(int index) {
        if (index >= 0 && index < 2) {
            return this.items.method_5438(index + 2).method_7972();
        }
        return class_1799.field_8037;
    }

    public class_1799 getItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getSellItem(index);
        }
        if (index >= 2 && index < 4) {
            return this.getBarterItem(index - 2);
        }
        return class_1799.field_8037;
    }

    public void setItem(class_1799 itemStack, int index) {
        if (index >= 0 && index < 4) {
            if (index < 2) {
                if (this.restriction.allowSellItem(itemStack) || itemStack.method_7960()) {
                    this.items.method_5447(index, this.restriction.filterSellItem(itemStack).method_7972());
                }
            } else {
                this.items.method_5447(index, itemStack.method_7972());
            }
        } else {
            LightmansCurrency.LogError("Cannot define the item trades item at index " + index + ". Must be between 0-3!");
        }
    }

    public boolean allowItemInStorage(class_1799 item) {
        for (int i = 0; i < (this.isBarter() ? 4 : 2); ++i) {
            if (!InventoryUtil.ItemMatches(item, this.getItem(i))) continue;
            return true;
        }
        return this.restriction.allowExtraItemInStorage(item);
    }

    public boolean hasCustomName(int index) {
        return !this.getCustomName(index).isEmpty();
    }

    public String getCustomName(int index) {
        switch (index) {
            case 0: {
                return this.customName1;
            }
            case 1: {
                return this.customName2;
            }
        }
        return "";
    }

    public void setCustomName(int index, String customName) {
        switch (index) {
            case 0: {
                this.customName1 = customName;
                return;
            }
            case 1: {
                this.customName2 = customName;
                return;
            }
        }
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        switch (this.tradeType) {
            case SALE: {
                return TradeData.TradeDirection.SALE;
            }
            case PURCHASE: {
                return TradeData.TradeDirection.PURCHASE;
            }
        }
        return TradeData.TradeDirection.NONE;
    }

    public ItemTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == ItemTradeType.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == ItemTradeType.PURCHASE;
    }

    @Override
    public boolean isBarter() {
        return this.tradeType == ItemTradeType.BARTER;
    }

    public void setTradeType(ItemTradeType tradeDirection) {
        this.tradeType = tradeDirection;
    }

    public int getSlotCount() {
        return this.tradeType == ItemTradeType.BARTER ? 2 : 1;
    }

    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == ItemTradeType.BARTER) {
            return this.sellItemsDefined() && this.barterItemsDefined();
        }
        return super.isValid() && this.sellItemsDefined();
    }

    public boolean sellItemsDefined() {
        return !this.getSellItem(0).method_7960() || !this.getSellItem(1).method_7960();
    }

    public boolean barterItemsDefined() {
        return !this.getBarterItem(0).method_7960() || !this.getBarterItem(1).method_7960();
    }

    public boolean hasStock(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasStock(TradeContext context) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(context) > 0;
    }

    public boolean hasSpace(ItemTraderData trader) {
        switch (this.tradeType) {
            case PURCHASE: {
                return trader.getStorage().canFitItems(this.getSellItem(0), this.getSellItem(1));
            }
            case BARTER: {
                return trader.getStorage().canFitItems(this.getBarterItem(0), this.getBarterItem(1));
            }
        }
        return true;
    }

    public int stockCount(ItemTraderData trader) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.cost.isFree()) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.cost.getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this.getSellItem(0), this.getSellItem(1));
        }
        return 0;
    }

    public int stockCount(TradeContext context) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (!context.hasTrader() || !(context.getTrader() instanceof ItemTraderData)) {
            return 0;
        }
        ItemTraderData trader = (ItemTraderData)context.getTrader();
        if (trader.isCreative()) {
            return 1;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.cost.isFree()) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.getCost(context).getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this.getSellItem(0), this.getSellItem(1));
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasItems(this.getSellItem(0), this.getSellItem(1));
        }
        if (this.isBarter()) {
            return context.hasItems(this.getBarterItem(0), this.getBarterItem(1));
        }
        return false;
    }

    public void RemoveItemsFromStorage(TraderItemStorage storage) {
        this.restriction.removeItemsFromStorage(storage, this.getSellItem(0), this.getSellItem(1));
    }

    @Override
    public class_2487 getAsNBT() {
        class_2487 tradeNBT = super.getAsNBT();
        InventoryUtil.saveAllItems("Items", tradeNBT, (class_1263)this.items);
        tradeNBT.method_10582("TradeDirection", this.tradeType.name());
        tradeNBT.method_10582("CustomName1", this.customName1);
        tradeNBT.method_10582("CustomName2", this.customName2);
        return tradeNBT;
    }

    public static class_2487 saveAllData(class_2487 nbt, List<ItemTradeData> data) {
        return ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static class_2487 saveAllData(class_2487 nbt, List<ItemTradeData> data, String key) {
        class_2499 listNBT = new class_2499();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)data.get(i).getAsNBT());
        }
        nbt.method_10566(key, (class_2520)listNBT);
        return nbt;
    }

    public static ItemTradeData loadData(class_2487 compound, boolean validateRules) {
        ItemTradeData trade = new ItemTradeData(validateRules);
        trade.loadFromNBT(compound);
        return trade;
    }

    public static List<ItemTradeData> loadAllData(class_2487 nbt, boolean validateRules) {
        return ItemTradeData.loadAllData("Trades", nbt, validateRules);
    }

    public static List<ItemTradeData> loadAllData(String key, class_2487 compound, boolean validateRules) {
        ArrayList<ItemTradeData> data = new ArrayList<ItemTradeData>();
        class_2499 listNBT = compound.method_10554(key, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            data.add(ItemTradeData.loadData(listNBT.method_10602(i), validateRules));
        }
        return data;
    }

    @Override
    public void loadFromNBT(class_2487 nbt) {
        super.loadFromNBT(nbt);
        if (nbt.method_10573("Items", 9)) {
            this.items = InventoryUtil.loadAllItems("Items", nbt, 4);
        }
        this.tradeType = nbt.method_10573("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.method_10558("TradeDirection")) : ItemTradeType.SALE;
        this.customName1 = nbt.method_10545("CustomName1") ? nbt.method_10558("CustomName1") : (nbt.method_10545("CustomName") ? nbt.method_10558("CustomName") : "");
        this.customName2 = nbt.method_10545("CustomName2") ? nbt.method_10558("CustomName2") : "";
    }

    public static ItemTradeType loadTradeType(String name) {
        ItemTradeType value = ItemTradeType.SALE;
        try {
            value = ItemTradeType.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount, boolean validateRules) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new ItemTradeData(validateRules));
        }
        return data;
    }

    public void markRulesDirty() {
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        TradeData.TradeComparisonResult result = new TradeData.TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResults(TradeData.TradeComparisonResult.ProductComparisonResult.CompareTwoItems(this.getSellItem(0), this.getSellItem(1), otherItemTrade.getSellItem(0), otherItemTrade.getSellItem(1)));
            if (this.isBarter()) {
                result.addProductResults(TradeData.TradeComparisonResult.ProductComparisonResult.CompareTwoItems(this.getBarterItem(0), this.getBarterItem(1), otherItemTrade.getBarterItem(0), otherItemTrade.getBarterItem(1)));
            }
            if (!this.isBarter()) {
                result.setPriceResult(this.getCost().getRawValue() - otherTrade.getCost().getRawValue());
            }
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        int i;
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            TradeData.TradeComparisonResult.ProductComparisonResult sellResult = result.getProductResult(i);
            if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
                if (!(this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() > 0 : this.isPurchase() && sellResult.ProductQuantityDifference() < 0)) continue;
                return false;
            }
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 4) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                TradeData.TradeComparisonResult.ProductComparisonResult barterResult = result.getProductResult(i + 2);
                if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                    if (barterResult.ProductQuantityDifference() >= 0) continue;
                    return false;
                }
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    @Override
    public List<class_2561> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (!differences.PriceMatches()) {
            long difference = differences.priceDifference();
            if (difference < 0L) {
                list.add((class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.interface.difference.expensive", (Object[])new Object[]{MoneyUtil.getStringOfValue(-difference)}).method_27692(class_124.field_1061));
            } else {
                list.add((class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.interface.difference.cheaper", (Object[])new Object[]{MoneyUtil.getStringOfValue(difference)}).method_27692(class_124.field_1061));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            class_5250 slotName = class_2561.method_43471((String)("gui.lightmanscurrency.interface.item.difference.product." + i));
            TradeData.TradeComparisonResult.ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.interface.item.difference.itemtype", (Object[])new Object[]{slotName}).method_27692(class_124.field_1061));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.interface.item.difference.itemnbt").method_27692(class_124.field_1061));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference < 0) {
                list.add((class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.interface.item.difference.quantity.more", (Object[])new Object[]{slotName, -quantityDifference}).method_27692(class_124.field_1061));
                continue;
            }
            list.add((class_2561)class_2561.method_43469((String)"gui.lightmanscurrency.interface.item.difference.quantity.less", (Object[])new Object[]{slotName, quantityDifference}).method_27692(class_124.field_1061));
        }
        return list;
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (this.isSale()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(this.getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.price_edit")}) : null)});
        }
        if (this.isPurchase()) {
            return this.getSaleItemEntries(context);
        }
        if (this.isBarter()) {
            return this.getBarterItemEntries(context);
        }
        return new ArrayList<DisplayEntry>();
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        if (this.isSale() || this.isBarter()) {
            return this.getSaleItemEntries(context);
        }
        if (this.isPurchase()) {
            return Lists.newArrayList((Object[])new DisplayEntry[]{DisplayEntry.of(this.getCost(context))});
        }
        return new ArrayList<DisplayEntry>();
    }

    private List<DisplayEntry> getSaleItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            class_1799 item = this.getSellItem(i);
            if (!item.method_7960()) {
                entries.add(DisplayEntry.of(item, item.method_7947(), this.getSaleItemTooltip(item, this.getCustomName(i), context)));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(DisplayEntry.of(this.restriction.getEmptySlotBG(), (List<class_2561>)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.item_edit")})));
        }
        return entries;
    }

    private List<class_2561> getSaleItemTooltip(class_1799 stack, String customName, TradeContext context) {
        if (stack.method_7960()) {
            if (context.isStorageMode) {
                return Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.item_edit")});
            }
            return null;
        }
        List<class_2561> tooltips = ItemRenderUtil.getTooltipFromItem(stack);
        class_2561 originalName = null;
        if (!customName.isEmpty() && (this.isSale() || this.isBarter())) {
            originalName = tooltips.get(0);
            tooltips.set(0, (class_2561)class_2561.method_43470((String)customName).method_27692(class_124.field_1065));
        }
        if (context.isStorageMode && originalName == null) {
            return tooltips;
        }
        tooltips.add((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.info").method_27692(class_124.field_1065));
        if (originalName != null) {
            tooltips.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.trader.originalname", (Object[])new Object[]{originalName}).method_27692(class_124.field_1065));
        }
        if (context.hasTrader() && context.hasPlayerReference() && context.getTrader() instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)context.getTrader();
            tooltips.add((class_2561)class_2561.method_43469((String)"tooltip.lightmanscurrency.trader.stock", (Object[])new Object[]{trader.isCreative() ? class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.stock.infinite").method_27692(class_124.field_1065) : class_2561.method_43470((String)String.valueOf(this.stockCount(context))).method_27692(class_124.field_1065)}).method_27692(class_124.field_1065));
        }
        return tooltips;
    }

    private List<DisplayEntry> getBarterItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            class_1799 item = this.getBarterItem(i);
            if (!item.method_7960()) {
                entries.add(DisplayEntry.of(item, item.method_7947(), ItemRenderUtil.getTooltipFromItem(item)));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(DisplayEntry.of(ItemRenderUtil.BACKGROUND, (List<class_2561>)Lists.newArrayList((Object[])new class_2561[]{class_2561.method_43471((String)"tooltip.lightmanscurrency.trader.item_edit")})));
        }
        return entries;
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(59, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        if (context.hasTrader() && context.getTrader() instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)context.getTrader();
            if (!trader.isCreative()) {
                if (this.stockCount(context) <= 0) {
                    alerts.add(AlertData.warn(class_2561.method_43471((String)"tooltip.lightmanscurrency.outofstock")));
                }
                if (!this.hasSpace(trader)) {
                    alerts.add(AlertData.warn(class_2561.method_43471((String)"tooltip.lightmanscurrency.outofspace")));
                }
            }
            if (!this.canAfford(context)) {
                alerts.add(AlertData.warn(class_2561.method_43471((String)"tooltip.lightmanscurrency.cannotafford")));
            }
        }
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)tab.menu.getTrader();
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                class_2487 extraData = new class_2487();
                extraData.method_10569("TradeIndex", tradeIndex);
                extraData.method_10569("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
            if (this.isPurchase() && index >= 0 && index < 2) {
                class_1799 sellItem = this.getSellItem(index);
                if (sellItem.method_7960() && heldItem.method_7960()) {
                    class_2487 extraData = new class_2487();
                    extraData.method_10569("TradeIndex", tradeIndex);
                    extraData.method_10569("StartingSlot", index);
                    tab.sendOpenTabMessage(2, extraData);
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.method_7939(Math.min(sellItem.method_7947() + 1, sellItem.method_7914()));
                    this.setItem(sellItem, index);
                } else {
                    class_1799 setItem = heldItem.method_7972();
                    if (button == 1) {
                        setItem.method_7939(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            } else if (this.isBarter() && index >= 0 && index < 2) {
                class_1799 barterItem = this.getBarterItem(index);
                if (barterItem.method_7960() && heldItem.method_7960()) {
                    class_2487 extraData = new class_2487();
                    extraData.method_10569("TradeIndex", tradeIndex);
                    extraData.method_10569("StartingSlot", index + 2);
                    tab.sendOpenTabMessage(2, extraData);
                }
                if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                    barterItem.method_7939(Math.min(barterItem.method_7947() + 1, barterItem.method_7914()));
                    this.setItem(barterItem, index + 2);
                } else {
                    class_1799 setItem = heldItem.method_7972();
                    if (button == 1) {
                        setItem.method_7939(1);
                    }
                    this.setItem(setItem, index + 2);
                }
                if (tab.menu.isClient()) {
                    tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            }
        }
    }

    public void onSlotInteraction(ItemTradeEditTab tab, int index, class_1799 heldItem, int button) {
        class_1799 setItem;
        if (index < 2) {
            class_1799 sellItem = this.getSellItem(index);
            if (sellItem.method_7960() && heldItem.method_7960()) {
                return;
            }
            if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                sellItem.method_7939(Math.min(sellItem.method_7947() + 1, sellItem.method_7914()));
                this.setItem(sellItem, index);
            } else {
                setItem = heldItem.method_7972();
                if (button == 1) {
                    setItem.method_7939(1);
                }
                this.setItem(setItem, index);
            }
        }
        if (this.isBarter() && index >= 2 && index < 4) {
            class_1799 barterItem = this.getItem(index);
            if (barterItem.method_7960() && heldItem.method_7960()) {
                return;
            }
            if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                barterItem.method_7939(Math.min(barterItem.method_7947() + 1, barterItem.method_7914()));
                this.setItem(barterItem, index);
            } else {
                setItem = heldItem.method_7972();
                if (button == 1) {
                    setItem.method_7939(1);
                }
                this.setItem(setItem, index);
            }
        }
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)tab.menu.getTrader();
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            if ((this.isSale() || this.isBarter()) && index >= 0 && index < 2) {
                class_1799 sellItem = this.getSellItem(index);
                if (sellItem.method_7960() && heldItem.method_7960()) {
                    class_2487 extraData = new class_2487();
                    extraData.method_10569("TradeIndex", tradeIndex);
                    extraData.method_10569("StartingSlot", index);
                    tab.sendOpenTabMessage(2, extraData);
                }
                if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.method_7939(Math.min(sellItem.method_7947() + 1, sellItem.method_7914()));
                    this.setItem(sellItem, index);
                } else {
                    class_1799 setItem = heldItem.method_7972();
                    if (button == 1) {
                        setItem.method_7939(1);
                    }
                    this.setItem(setItem, index);
                }
                if (tab.menu.isClient()) {
                    tab.sendOutputInteractionMessage(tradeIndex, index, button, heldItem);
                }
            } else if (this.isPurchase()) {
                class_2487 extraData = new class_2487();
                extraData.method_10569("TradeIndex", tradeIndex);
                extraData.method_10569("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, class_1799 heldItem) {
        if (tab.menu.getTrader() instanceof ItemTraderData) {
            ItemTraderData it = (ItemTraderData)tab.menu.getTrader();
            int tradeIndex = it.indexOfTrade(this);
            if (tradeIndex < 0) {
                return;
            }
            class_2487 extraData = new class_2487();
            extraData.method_10569("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    public static enum ItemTradeType {
        SALE(0, 1),
        PURCHASE(1, 2),
        BARTER(2, 0);

        public final int index;
        private final int nextIndex;

        public final ItemTradeType next() {
            return ItemTradeType.fromIndex(this.nextIndex);
        }

        private ItemTradeType(int index, int nextIndex) {
            this.index = index;
            this.nextIndex = nextIndex;
        }

        public static ItemTradeType fromIndex(int index) {
            for (ItemTradeType type : ItemTradeType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return SALE;
        }
    }
}

