/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.events;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.AlertData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_5250;

public abstract class TradeEvent {
    public static final Event<PreTradeCallback> PRE_TRADE_EVENT = EventFactory.createArrayBacked(PreTradeCallback.class, listeners -> preTradeEvent -> {
        for (PreTradeCallback listener : listeners) {
            listener.react(preTradeEvent);
        }
    });
    public static final Event<TradeCostCallback> TRADE_COST_EVENT = EventFactory.createArrayBacked(TradeCostCallback.class, listeners -> tradeCostEvent -> {
        for (TradeCostCallback listener : listeners) {
            listener.editCost(tradeCostEvent);
        }
    });
    public static final Event<PostTradeCallback> POST_TRADE_EVENT = EventFactory.createArrayBacked(PostTradeCallback.class, listeners -> postTradeEvent -> {
        for (PostTradeCallback listener : listeners) {
            listener.listen(postTradeEvent);
        }
    });
    private final PlayerReference player;
    private final TradeData trade;
    private final TraderData trader;

    public final PlayerReference getPlayerReference() {
        return this.player;
    }

    @Deprecated
    public final class_1657 getPlayer() {
        return this.player.getPlayer();
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final int getTradeIndex() {
        return this.trader.indexOfTrade(this.trade);
    }

    public final TraderData getTrader() {
        return this.trader;
    }

    protected TradeEvent(PlayerReference player, TradeData trade, TraderData trader) {
        this.player = player;
        this.trade = trade;
        this.trader = trader;
    }

    public static interface PostTradeCallback {
        public void listen(PostTradeEvent var1);
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final CoinValue pricePaid;

        public CoinValue getPricePaid() {
            return this.pricePaid;
        }

        public PostTradeEvent(PlayerReference player, TradeData trade, TraderData trader, CoinValue pricePaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static interface TradeCostCallback {
        public void editCost(TradeCostEvent var1);
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private double costMultiplier = 1.0;
        CoinValue currentCost;

        public double getCostMultiplier() {
            return this.costMultiplier;
        }

        public void applyCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(this.costMultiplier * newCostMultiplier, 0.0, 2.0);
        }

        public void setCostMultiplier(double newCostMultiplier) {
            this.costMultiplier = MathUtil.clamp(newCostMultiplier, 0.0, 2.0);
        }

        public CoinValue getBaseCost() {
            return this.currentCost;
        }

        public CoinValue getCostResult() {
            return this.currentCost.ApplyMultiplier(this.costMultiplier);
        }

        public TradeCostEvent(PlayerReference player, TradeData trade, TraderData trader) {
            super(player, trade, trader);
            this.currentCost = trade.getCost();
        }
    }

    public static interface PreTradeCallback {
        public void react(PreTradeEvent var1);
    }

    public static class PreTradeEvent
    extends TradeEvent {
        private final List<AlertData> alerts = new ArrayList<AlertData>();
        private boolean cancelled = false;

        public boolean isCanceled() {
            return this.cancelled;
        }

        public PreTradeEvent(PlayerReference player, TradeData trade, TraderData trader) {
            super(player, trade, trader);
        }

        public void addAlert(AlertData alert, boolean cancelTrade) {
            this.alerts.add(alert);
            if (cancelTrade) {
                this.cancelled = true;
            }
        }

        public void addHelpful(class_5250 message) {
            this.addAlert(AlertData.helpful(message), false);
        }

        public void addWarning(class_5250 message) {
            this.addAlert(AlertData.warn(message), false);
        }

        public void addError(class_5250 message) {
            this.addAlert(AlertData.error(message), false);
        }

        public void addDenial(class_5250 message) {
            this.addAlert(AlertData.error(message), true);
        }

        public List<AlertData> getAlertInfo() {
            return this.alerts;
        }
    }
}

