/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class AuctionPlayerStorage {
    PlayerReference owner;
    CoinValue storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
    List<class_1799> storedItems = new ArrayList<class_1799>();

    public PlayerReference getOwner() {
        return this.owner;
    }

    public CoinValue getStoredCoins() {
        return this.storedCoins;
    }

    public List<class_1799> getStoredItems() {
        return this.storedItems;
    }

    public AuctionPlayerStorage(PlayerReference player) {
        this.owner = player;
    }

    public AuctionPlayerStorage(class_2487 compound) {
        this.load(compound);
    }

    public class_2487 save(class_2487 compound) {
        compound.method_10566("Owner", (class_2520)this.owner.save());
        this.storedCoins.save(compound, "StoredMoney");
        class_2499 itemList = new class_2499();
        for (int i = 0; i < this.storedItems.size(); ++i) {
            itemList.add((Object)this.storedItems.get(i).method_7953(new class_2487()));
        }
        compound.method_10566("StoredItems", (class_2520)itemList);
        return compound;
    }

    protected void load(class_2487 compound) {
        this.owner = PlayerReference.load(compound.method_10562("Owner"));
        this.storedCoins.load(compound, "StoredMoney");
        this.storedItems.clear();
        class_2499 itemList = compound.method_10554("StoredItems", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            class_1799 stack = class_1799.method_7915((class_2487)itemList.method_10602(i));
            if (stack.method_7960()) continue;
            this.storedItems.add(stack);
        }
    }

    public void giveMoney(CoinValue amount) {
        this.storedCoins.addValue(amount);
    }

    public CoinValue takeMoney(CoinValue amount) {
        long newValue = this.storedCoins.getRawValue() - amount.getRawValue();
        if (newValue < 0L) {
            this.storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
            return new CoinValue(-newValue);
        }
        this.storedCoins.loadFromOldValue(newValue);
        return new CoinValue(new CoinValue.CoinValuePair[0]);
    }

    public void collectedMoney(class_1657 player) {
        MoneyUtil.ProcessChange(null, player, this.storedCoins.copy());
        this.storedCoins = new CoinValue(new CoinValue.CoinValuePair[0]);
    }

    public void giveItem(class_1799 item) {
        if (!item.method_7960()) {
            this.storedItems.add(item);
        }
    }

    public void removePartial(int itemSlot, int count) {
        if (this.storedItems.size() >= itemSlot || itemSlot < 0) {
            return;
        }
        this.storedItems.get(itemSlot).method_7934(count);
        if (this.storedItems.get(itemSlot).method_7960()) {
            this.storedItems.remove(itemSlot);
        }
    }

    public void collectItems(class_1657 player) {
        for (class_1799 stack : this.storedItems) {
            InventoryUtil.GiveToPlayer(player, stack);
        }
        this.storedItems = new ArrayList<class_1799>();
    }
}

