/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core.AllyTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core.MainTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core.NotificationTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core.OwnershipTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core.PermissionsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.menu.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.network.client.messages.trader.SMessageSyncUserCount;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageTraderMessage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public abstract class TraderData
implements IClientTracker,
IDumpable,
UpgradeType.IUpgradeable,
ITraderSource {
    public static final int GLOBAL_TRADE_LIMIT = 32;
    private boolean canMarkDirty = false;
    public final class_2960 type;
    private long id = -1L;
    private boolean alwaysShowOnTerminal = false;
    private boolean creative = false;
    private boolean isClient = false;
    private final OwnerData owner = new OwnerData(this, o -> this.markDirty(this::saveOwner));
    private final List<PlayerReference> allies = new ArrayList<PlayerReference>();
    private final Map<String, Integer> allyPermissions = this.getDefaultAllyPermissions();
    private final NotificationData logger = new NotificationData();
    private String customName = "";
    private class_1792 traderBlock;
    private CoinValue storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
    private boolean linkedToBank = false;
    private class_1277 upgrades;
    private List<TradeRule> rules = new ArrayList<TradeRule>();
    private boolean notificationsEnabled = false;
    private boolean notificationsToChat = true;
    private int teamNotificationLevel = 0;
    private class_5321<class_1937> level = class_1937.field_25179;
    private class_2338 pos = new class_2338(0, 0, 0);
    private String persistentID = "";
    private static final Map<String, Supplier<TraderData>> deserializers = new HashMap<String, Supplier<TraderData>>();
    private int userCount = 0;
    private final List<class_1657> currentUsers = new ArrayList<class_1657>();

    public final TraderData allowMarkingDirty() {
        this.canMarkDirty = true;
        return this;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setAlwaysShowOnTerminal() {
        this.alwaysShowOnTerminal = true;
        this.markDirty(this::saveShowOnTerminal);
    }

    public boolean shouldAlwaysShowOnTerminal() {
        return this.alwaysShowOnTerminal;
    }

    public boolean canShowOnTerminal() {
        return true;
    }

    public boolean showOnTerminal() {
        if (this.alwaysShowOnTerminal) {
            return true;
        }
        return this.hasNetworkUpgrade();
    }

    protected final boolean hasNetworkUpgrade() {
        return UpgradeType.hasUpgrade(UpgradeType.NETWORK, (class_1263)this.upgrades);
    }

    public void setCreative(class_1657 player, boolean creative) {
        if (this.hasPermission(player, "LC_ADMIN_MODE") && this.creative != creative) {
            this.creative = creative;
            this.markDirty(this::saveCreative);
            if (player != null) {
                this.pushLocalNotification(new ChangeCreativeNotification(PlayerReference.of(player), this.creative));
            }
        }
    }

    public boolean isCreative() {
        return this.creative;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public final OwnerData getOwner() {
        return this.owner;
    }

    public final List<PlayerReference> getAllies() {
        return new ArrayList<PlayerReference>(this.allies);
    }

    private Map<String, Integer> getDefaultAllyPermissions() {
        HashMap<String, Integer> defaultValues = new HashMap<String, Integer>();
        defaultValues.put("openStorage", 1);
        defaultValues.put("editTrades", 1);
        defaultValues.put("editTradeRules", 1);
        defaultValues.put("editSettings", 1);
        defaultValues.put("changeName", 1);
        defaultValues.put("viewLogs", 1);
        defaultValues.put("notifications", 1);
        this.modifyDefaultAllyPermissions(defaultValues);
        return defaultValues;
    }

    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
    }

    public boolean hasPermission(class_1657 player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    public boolean hasPermission(PlayerReference player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    public int getPermissionLevel(class_1657 player, String permission) {
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(PlayerReference.of(player))) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    public int getPermissionLevel(PlayerReference player, String permission) {
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(player)) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    public int getAllyPermissionLevel(String permission) {
        return this.allyPermissions.getOrDefault(permission, 0);
    }

    public void setAllyPermissionLevel(class_1657 player, String permission, int level) {
        if (this.hasPermission(player, "editPermissions") && this.getAllyPermissionLevel(permission) != level) {
            int oldLevel = this.getAllyPermissionLevel(permission);
            this.allyPermissions.put(permission, level);
            this.markDirty(this::saveAllyPermissions);
            if (player != null) {
                this.pushLocalNotification(new ChangeAllyPermissionNotification(PlayerReference.of(player), permission, level, oldLevel));
            }
        }
    }

    private boolean isAdmin(class_1657 player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAdmin(PlayerReference player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAlly(PlayerReference player) {
        if (this.owner.isMember(player)) {
            return true;
        }
        for (PlayerReference ally : this.allies) {
            if (!ally.is(player)) continue;
            return true;
        }
        return false;
    }

    public final List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public boolean hasCustomName() {
        return this.customName.length() > 0;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(class_1657 player, String name) {
        if (this.hasPermission(player, "changeName") && !this.customName.equals(name)) {
            String oldName = this.customName;
            this.customName = name;
            this.markDirty(this::saveName);
            if (player != null) {
                this.pushLocalNotification(new ChangeNameNotification(PlayerReference.of(player), this.customName, oldName));
            }
        }
    }

    public abstract IconData getIcon();

    @Override
    public class_5250 getName() {
        if (this.hasCustomName()) {
            return class_2561.method_43470((String)this.customName);
        }
        return this.getDefaultName();
    }

    public final class_5250 getTitle() {
        if (this.creative) {
            return this.getName();
        }
        return class_2561.method_43469((String)"gui.lightmanscurrency.trading.title", (Object[])new Object[]{this.getName(), this.owner.getOwnerName(this.isClient)});
    }

    protected class_5250 getDefaultName() {
        if (this.traderBlock != null) {
            return class_2561.method_43470((String)new class_1799((class_1935)this.traderBlock).method_7964().getString());
        }
        return class_2561.method_43471((String)"gui.lightmanscurrency.universaltrader.default");
    }

    public CoinValue getStoredMoney() {
        BankAccount ba = this.getBankAccount();
        if (ba != null) {
            return ba.getCoinStorage();
        }
        return this.storedMoney.copy();
    }

    public CoinValue getInternalStoredMoney() {
        return this.storedMoney.copy();
    }

    public void addStoredMoney(CoinValue amount) {
        BankAccount ba = this.getBankAccount();
        if (ba != null) {
            ba.depositCoins(amount);
            ba.LogInteraction(this, amount, true);
            return;
        }
        this.storedMoney.addValue(amount);
        this.markDirty(this::saveStoredMoney);
    }

    public void removeStoredMoney(CoinValue amount) {
        BankAccount ba = this.getBankAccount();
        if (ba != null) {
            ba.withdrawCoins(amount);
            ba.LogInteraction(this, amount, false);
            return;
        }
        this.storedMoney.removeValue(amount);
        this.markDirty(this::saveStoredMoney);
    }

    public void clearStoredMoney() {
        this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
        this.markDirty(this::saveStoredMoney);
    }

    public boolean getLinkedToBank() {
        return this.linkedToBank;
    }

    public boolean canLinkBankAccount() {
        if (this.owner.hasTeam()) {
            return this.owner.getTeam().hasBankAccount();
        }
        return true;
    }

    public void setLinkedToBank(class_1657 player, boolean linkedToBank) {
        if (this.hasPermission(player, "bankLink") && linkedToBank != this.linkedToBank) {
            this.linkedToBank = linkedToBank;
            if (this.linkedToBank) {
                BankAccount account = this.getBankAccount();
                if (account != null) {
                    account.depositCoins(this.storedMoney);
                    this.storedMoney = new CoinValue(new CoinValue.CoinValuePair[0]);
                    this.markDirty(this::saveStoredMoney);
                } else {
                    this.linkedToBank = false;
                }
            }
            this.markDirty(this::saveLinkedBankAccount);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "BankLink", String.valueOf(this.linkedToBank)));
            }
        }
    }

    public boolean hasBankAccount() {
        return this.getBankAccount() != null;
    }

    public BankAccount getBankAccount() {
        if (this.linkedToBank) {
            PlayerReference player;
            Team team;
            if (this.owner.hasTeam() && (team = this.owner.getTeam()) != null && team.hasBankAccount()) {
                return team.getBankAccount();
            }
            if (this.owner.hasPlayer() && (player = this.owner.getPlayer()) != null) {
                return BankSaveData.GetBankAccount(this.isClient, player.id);
            }
        }
        return null;
    }

    public class_1263 getUpgrades() {
        return this.upgrades;
    }

    @Override
    public final boolean allowUpgrade(UpgradeType type) {
        if (!this.showOnTerminal() && this.canShowOnTerminal() && type == UpgradeType.NETWORK) {
            return true;
        }
        return this.allowAdditionalUpgradeType(type);
    }

    protected abstract boolean allowAdditionalUpgradeType(UpgradeType var1);

    public List<TradeRule> getRules() {
        return Lists.newArrayList(this.rules);
    }

    public boolean notificationsEnabled() {
        return this.notificationsEnabled;
    }

    public boolean notificationsToChat() {
        return this.notificationsToChat;
    }

    public int teamNotificationLevel() {
        return this.teamNotificationLevel;
    }

    public abstract int getTradeCount();

    public boolean canEditTradeCount() {
        return false;
    }

    public int getMaxTradeCount() {
        return 1;
    }

    public abstract int getTradeStock(int var1);

    public abstract boolean hasValidTrade();

    public class_5321<class_1937> getLevel() {
        return this.level;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void move(class_1937 level, class_2338 pos) {
        if (level != null) {
            this.level = level.method_27983();
        }
        if (pos != null) {
            this.pos = pos;
        }
        if (this.id >= 0L) {
            this.markDirty(this::saveLevelData);
        }
    }

    protected TraderData(class_2960 type) {
        this.type = type;
        this.upgrades = new class_1277(5);
        this.upgrades.method_5489(c -> this.markDirty(this::saveUpgrades));
        TradeRule.ValidateTradeRuleList(this.rules, this::allowTradeRule);
    }

    protected TraderData(class_2960 type, class_1937 level, class_2338 pos) {
        this(type);
        this.level = level == null ? class_1937.field_25179 : level.method_27983();
        this.pos = pos == null ? new class_2338(0, 0, 0) : pos;
        this.traderBlock = level == null ? ModItems.TRADING_CORE : level.method_8320(pos).method_26204().method_8389();
    }

    public boolean isPersistent() {
        return this.persistentID.length() > 0;
    }

    public String getPersistentID() {
        return this.persistentID;
    }

    public void makePersistent(long id, String persistentID) {
        this.id = id;
        this.persistentID = persistentID;
        this.creative = true;
        this.alwaysShowOnTerminal = true;
    }

    protected final void markDirty(class_2487 updateData) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        updateData.method_10544("ID", this.id);
        TraderSaveData.MarkTraderDirty(updateData);
    }

    @SafeVarargs
    protected final void markDirty(Consumer<class_2487> ... updateWriters) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        class_2487 updateData = new class_2487();
        for (Consumer<class_2487> u : updateWriters) {
            u.accept(updateData);
        }
        this.markDirty(updateData);
    }

    public final class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10582("Type", this.type.toString());
        compound.method_10544("ID", this.id);
        this.saveLevelData(compound);
        this.saveTraderItem(compound);
        this.saveOwner(compound);
        this.saveAllies(compound);
        this.saveAllyPermissions(compound);
        this.saveName(compound);
        this.saveCreative(compound);
        this.saveShowOnTerminal(compound);
        this.saveRules(compound);
        this.saveUpgrades(compound);
        this.saveStoredMoney(compound);
        this.saveLinkedBankAccount(compound);
        this.saveLogger(compound);
        this.saveNotificationData(compound);
        if (this.persistentID.length() > 0) {
            compound.method_10582("PersistentTraderID", this.persistentID);
        }
        this.saveAdditional(compound);
        return compound;
    }

    public final void saveLevelData(class_2487 compound) {
        if (this.pos != null) {
            class_2487 posTag = new class_2487();
            posTag.method_10569("x", this.pos.method_10263());
            posTag.method_10569("y", this.pos.method_10264());
            posTag.method_10569("z", this.pos.method_10260());
            compound.method_10566("WorldPos", (class_2520)posTag);
        }
        if (this.level != null) {
            compound.method_10582("Level", this.level.method_29177().toString());
        }
    }

    private void saveTraderItem(class_2487 compound) {
        if (this.traderBlock != null) {
            compound.method_10582("TraderBlock", class_7923.field_41178.method_10221((Object)this.traderBlock).toString());
        }
    }

    protected final void saveOwner(class_2487 compound) {
        compound.method_10566("OwnerData", (class_2520)this.owner.save());
    }

    protected final void saveAllies(class_2487 compound) {
        class_2499 allyData = new class_2499();
        for (PlayerReference ally : this.allies) {
            allyData.add((Object)ally.save());
        }
        compound.method_10566("Allies", (class_2520)allyData);
    }

    protected final void saveAllyPermissions(class_2487 compound) {
        class_2499 allyPermList = new class_2499();
        this.allyPermissions.forEach((perm, level) -> {
            class_2487 tag = new class_2487();
            if (level != 0) {
                tag.method_10582("Permission", perm);
                tag.method_10569("Level", level.intValue());
                allyPermList.add((Object)tag);
            }
        });
        compound.method_10566("AllyPermissions", (class_2520)allyPermList);
    }

    protected final void saveName(class_2487 compound) {
        compound.method_10582("Name", this.customName);
    }

    protected final void saveCreative(class_2487 compound) {
        compound.method_10556("Creative", this.creative);
    }

    protected final void saveShowOnTerminal(class_2487 compound) {
        compound.method_10556("AlwaysShowOnTerminal", this.alwaysShowOnTerminal);
    }

    protected final void saveRules(class_2487 compound) {
        TradeRule.saveRules(compound, this.rules, "RuleData");
    }

    protected final void saveUpgrades(class_2487 compound) {
        InventoryUtil.saveAllItems("Upgrades", compound, (class_1263)this.upgrades);
    }

    protected final void saveStoredMoney(class_2487 compound) {
        this.storedMoney.save(compound, "StoredMoney");
    }

    protected final void saveLinkedBankAccount(class_2487 compound) {
        compound.method_10556("LinkedToBank", this.linkedToBank);
    }

    protected final void saveLogger(class_2487 compound) {
        compound.method_10566("Logger", (class_2520)this.logger.save());
    }

    protected final void saveNotificationData(class_2487 compound) {
        compound.method_10556("NotificationsEnabled", this.notificationsEnabled);
        compound.method_10556("ChatNotifications", this.notificationsToChat);
        compound.method_10569("TeamNotifications", this.teamNotificationLevel);
    }

    protected abstract void saveTrades(class_2487 var1);

    protected abstract void saveAdditional(class_2487 var1);

    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    public void markRulesDirty() {
        this.markDirty(this::saveRules);
    }

    public final JsonObject saveToJson() throws Exception {
        if (!this.canMakePersistent()) {
            throw new Exception("Trader of type '" + this.type.toString() + "' cannot be saved to JSON!");
        }
        JsonObject json = new JsonObject();
        json.addProperty("Type", this.type.toString());
        json.addProperty("Name", this.hasCustomName() ? this.customName : "Trader");
        JsonArray ruleData = TradeRule.saveRulesToJson(this.rules);
        if (ruleData.size() > 0) {
            json.add("Rules", (JsonElement)ruleData);
        }
        this.saveAdditionalToJson(json);
        return json;
    }

    protected abstract void saveAdditionalToJson(JsonObject var1);

    public final void load(class_2487 compound) {
        int i;
        if (compound.method_10573("ID", 4)) {
            this.setID(compound.method_10537("ID"));
        }
        if (compound.method_10545("PersistentTraderID")) {
            this.persistentID = compound.method_10558("PersistentTraderID");
        }
        if (compound.method_10545("WorldPos")) {
            class_2487 posTag = compound.method_10562("WorldPos");
            this.pos = new class_2338(posTag.method_10550("x"), posTag.method_10550("y"), posTag.method_10550("z"));
        }
        if (compound.method_10545("Level")) {
            this.level = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("Level")));
        }
        if (compound.method_10545("TraderBlock")) {
            try {
                this.traderBlock = (class_1792)class_7923.field_41178.method_10223(new class_2960(compound.method_10558("TraderBlock")));
            }
            catch (Throwable posTag) {
                // empty catch block
            }
        }
        if (compound.method_10573("OwnerData", 10)) {
            this.owner.load(compound.method_10562("OwnerData"));
        }
        if (compound.method_10545("Allies")) {
            this.allies.clear();
            class_2499 allyList = compound.method_10554("Allies", 10);
            for (i = 0; i < allyList.size(); ++i) {
                PlayerReference ally = PlayerReference.load(allyList.method_10602(i));
                if (ally == null) continue;
                this.allies.add(ally);
            }
        }
        if (compound.method_10545("AllyPermissions")) {
            this.allyPermissions.clear();
            class_2499 allyPermList = compound.method_10554("AllyPermissions", 10);
            for (i = 0; i < allyPermList.size(); ++i) {
                class_2487 tag = allyPermList.method_10602(i);
                String perm = tag.method_10558("Permission");
                int level = tag.method_10550("Level");
                this.allyPermissions.put(perm, level);
            }
        }
        if (compound.method_10545("Name")) {
            this.customName = compound.method_10558("Name");
        }
        if (compound.method_10545("Creative")) {
            this.creative = compound.method_10577("Creative");
        }
        if (compound.method_10545("AlwaysShowOnTerminal")) {
            this.alwaysShowOnTerminal = compound.method_10577("AlwaysShowOnTerminal");
        }
        if (compound.method_10545("RuleData")) {
            this.rules = TradeRule.loadRules(compound, "RuleData");
            if (!this.isPersistent()) {
                TradeRule.ValidateTradeRuleList(this.rules, this::allowTradeRule);
            }
        }
        if (compound.method_10545("Upgrades")) {
            this.upgrades = InventoryUtil.loadAllItems("Upgrades", compound, 5);
            this.upgrades.method_5489(c -> this.markDirty(this::saveUpgrades));
        }
        if (compound.method_10545("StoredMoney")) {
            this.storedMoney.load(compound, "StoredMoney");
        }
        if (compound.method_10545("LinkedToBank")) {
            this.linkedToBank = compound.method_10577("LinkedToBank");
        }
        if (compound.method_10545("Logger")) {
            this.logger.load(compound.method_10562("Logger"));
        }
        if (compound.method_10545("NotificationsEnabled")) {
            this.notificationsEnabled = compound.method_10577("NotificationsEnabled");
        }
        if (compound.method_10545("ChatNotifications")) {
            this.notificationsToChat = compound.method_10577("ChatNotifications");
        }
        if (compound.method_10545("TeamNotifications")) {
            this.teamNotificationLevel = compound.method_10550("TeamNotifications");
        }
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(class_2487 var1);

    public final void loadFromJson(JsonObject json) throws Exception {
        if (json.has("OwnerName")) {
            this.owner.SetCustomOwner(json.get("OwnerName").getAsString());
        } else {
            this.owner.SetCustomOwner("Server");
        }
        if (json.has("Name")) {
            this.customName = json.get("Name").getAsString();
        }
        if (json.has("Rules")) {
            this.rules = TradeRule.Parse(json.getAsJsonArray("Rules"));
        }
        this.loadAdditionalFromJson(json);
    }

    protected abstract void loadAdditionalFromJson(JsonObject var1) throws Exception;

    public final class_2487 savePersistentData() {
        class_2487 compound = new class_2487();
        TradeRule.savePersistentData(compound, this.rules, "RuleData");
        this.saveAdditionalPersistentData(compound);
        return compound;
    }

    protected abstract void saveAdditionalPersistentData(class_2487 var1);

    public final void loadPersistentData(class_2487 compound) {
        TradeRule.loadPersistentData(compound, this.rules, "RuleData");
        this.loadAdditionalPersistentData(compound);
    }

    protected abstract void loadAdditionalPersistentData(class_2487 var1);

    public void openTraderMenu(class_1657 player) {
        player.method_17355((class_3908)this.getTraderMenuProvider());
    }

    protected ExtendedScreenHandlerFactory getTraderMenuProvider() {
        return new TraderMenuProvider(this.id);
    }

    public void openStorageMenu(class_1657 player) {
        if (!this.hasPermission(player, "openStorage")) {
            return;
        }
        player.method_17355(this.getTraderStorageMenuProvider());
    }

    protected class_3908 getTraderStorageMenuProvider() {
        return new TraderStorageMenuProvider(this.id);
    }

    public TradeEvent.PreTradeEvent runPreTradeEvent(PlayerReference player, TradeData trade) {
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(player, trade, this);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
        trade.beforeTrade(event);
        ((TradeEvent.PreTradeCallback)TradeEvent.PRE_TRADE_EVENT.invoker()).react(event);
        return event;
    }

    public TradeEvent.TradeCostEvent runTradeCostEvent(PlayerReference player, TradeData trade) {
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(player, trade, this);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
        trade.tradeCost(event);
        ((TradeEvent.TradeCostCallback)TradeEvent.TRADE_COST_EVENT.invoker()).editCost(event);
        return event;
    }

    public TradeEvent.PostTradeEvent runPostTradeEvent(PlayerReference player, TradeData trade, CoinValue cost) {
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(player, trade, this, cost);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
        if (event.isDirty()) {
            this.markRulesDirty();
        }
        event.clean();
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
        }
        event.clean();
        ((TradeEvent.PostTradeCallback)TradeEvent.POST_TRADE_EVENT.invoker()).listen(event);
        return event;
    }

    public Storage<ItemVariant> getItemStorage(class_2350 relativeSide) {
        return null;
    }

    public Storage<FluidVariant> getFluidStorage(class_2350 relativeSide) {
        return null;
    }

    @Override
    @NotNull
    public final List<class_1799> getContents(class_1937 level, class_2338 pos, class_2680 state, boolean dropBlock) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        if (dropBlock) {
            class_1799 blockStack;
            class_2248 block = state != null ? state.method_26204() : null;
            class_1799 class_17992 = blockStack = block != null ? new class_1799((class_1935)block) : class_1799.field_8037;
            if (block instanceof ITraderBlock) {
                ITraderBlock b = (ITraderBlock)block;
                blockStack = b.getDropBlockItem(level, pos, state);
            }
            if (!blockStack.method_7960()) {
                results.add(blockStack);
            } else {
                LightmansCurrency.LogWarning("Block drop for trader is empty!");
            }
        }
        for (int i = 0; i < this.upgrades.method_5439(); ++i) {
            class_1799 stack = this.upgrades.method_5438(i);
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        for (CoinValue.CoinValuePair entry : this.storedMoney.getEntries()) {
            class_1799 stack = new class_1799((class_1935)entry.coin, entry.amount);
            while (stack.method_7947() > stack.method_7914()) {
                results.add(stack.method_7971(stack.method_7914()));
            }
            if (stack.method_7960()) continue;
            results.add(stack);
        }
        this.getAdditionalContents(results);
        return results;
    }

    protected abstract void getAdditionalContents(List<class_1799> var1);

    public static void register(class_2960 type, @NotNull Supplier<TraderData> source) {
        String t = type.toString();
        if (deserializers.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to register duplicate TraderData type '" + t + "'!");
            return;
        }
        deserializers.put(t, source);
    }

    public static TraderData Deserialize(boolean isClient, class_2487 compound) {
        if (compound.method_10545("Type")) {
            String type = compound.method_10558("Type");
            if (deserializers.containsKey(type)) {
                TraderData data = deserializers.get(type).get();
                if (isClient) {
                    data.flagAsClient();
                }
                data.load(compound);
                return data;
            }
            LightmansCurrency.LogWarning("Could not deserialize TraderData of type '" + type + "' as no deserializer for that type has been registered!");
            return null;
        }
        LightmansCurrency.LogError("Could not deserialize TraderData as no 'Type' entry was given!\n" + compound.method_10714());
        return null;
    }

    public static TraderData Deserialize(JsonObject json) throws Exception {
        if (!(json.has("Type") && json.get("Type").isJsonPrimitive() && json.get("Type").getAsJsonPrimitive().isString())) {
            throw new Exception("No string 'Type' entry for this trader.");
        }
        String thisType = json.get("Type").getAsString();
        if (deserializers.containsKey(thisType)) {
            TraderData data = deserializers.get(thisType).get();
            data.loadFromJson(json);
            return data;
        }
        throw new Exception("Trader type '" + thisType + "' is undefined.");
    }

    public boolean shouldRemove(MinecraftServer server) {
        if (this.level == null || this.pos == null) {
            return false;
        }
        class_3218 level = server.method_3847(this.level);
        if (level != null && level.method_22340(this.pos)) {
            class_2586 be = level.method_8321(this.pos);
            if (be instanceof TraderBlockEntity) {
                TraderBlockEntity tbe = (TraderBlockEntity)be;
                return tbe.getTraderID() != this.id;
            }
            return true;
        }
        return false;
    }

    public void onServerTick(MinecraftServer server) {
    }

    public final List<class_1657> getUsers() {
        return new ArrayList<class_1657>(this.currentUsers);
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void userOpen(class_1657 player) {
        this.currentUsers.add(player);
        this.updateUserCount();
    }

    public void userClose(class_1657 player) {
        this.currentUsers.remove(player);
        this.updateUserCount();
    }

    private void updateUserCount() {
        if (this.isServer()) {
            this.userCount = this.currentUsers.size();
            new SMessageSyncUserCount(this.id, this.userCount).sendToAll();
        }
    }

    public void updateUserCount(int userCount) {
        if (this.isClient) {
            this.userCount = userCount;
        }
    }

    public abstract List<? extends TradeData> getTradeData();

    public int indexOfTrade(TradeData trade) {
        return this.getTradeData().indexOf(trade);
    }

    public abstract void addTrade(class_1657 var1);

    public abstract void removeTrade(class_1657 var1);

    public boolean allowTradeRule(TradeRule rule) {
        return true;
    }

    public abstract TradeContext.TradeResult ExecuteTrade(TradeContext var1, int var2);

    public abstract void addInteractionSlots(List<InteractionSlotData> var1);

    public abstract boolean canMakePersistent();

    public Function<TradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return TradeButtonArea.FILTER_ANY;
    }

    public abstract void initStorageTabs(TraderStorageMenu var1);

    public final void sendTradeRuleMessage(int tradeIndex, class_2960 type, class_2487 updateInfo) {
        if (this.isClient) {
            class_2487 message = new class_2487();
            message.method_10582("TradeRuleEdit", type.toString());
            message.method_10569("TradeIndex", tradeIndex);
            message.method_10566("TradeRuleData", (class_2520)updateInfo);
            this.sendNetworkMessage(message);
        }
    }

    public final void sendNetworkMessage(class_2487 message) {
        if (this.isClient && message != null) {
            new CMessageTraderMessage(this.id, message).sendToServer();
        }
    }

    public void receiveNetworkMessage(class_1657 player, class_2487 message) {
        int level;
        boolean enable;
        boolean enable2;
        PlayerReference oldAlly;
        PlayerReference newAlly;
        Team team;
        PlayerReference oldPlayer;
        Team oldTeam;
        PlayerReference newOwner;
        if (message.method_10545("ChangePlayerOwner") && this.hasPermission(player, "transferOwnership") && (newOwner = PlayerReference.of(this.isClient, message.method_10558("ChangePlayerOwner"))) != null && (this.owner.hasTeam() || !newOwner.is(this.owner.getPlayer()))) {
            oldTeam = this.owner.getTeam();
            oldPlayer = this.owner.getPlayer();
            this.owner.SetOwner(newOwner);
            if (this.linkedToBank) {
                this.linkedToBank = false;
                this.markDirty(this::saveLinkedBankAccount);
            }
            if (player != null) {
                if (oldTeam != null) {
                    this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldTeam));
                } else if (oldPlayer != null) {
                    this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldPlayer));
                }
            }
        }
        if (message.method_10545("ChangeTeamOwner") && this.hasPermission(player, "transferOwnership") && (team = TeamSaveData.GetTeam(this.isClient, message.method_10537("ChangeTeamOwner"))) != null && team.isMember(player) && team != this.owner.getTeam()) {
            oldTeam = this.owner.getTeam();
            oldPlayer = this.owner.getPlayer();
            this.owner.SetOwner(team);
            if (this.linkedToBank) {
                this.linkedToBank = false;
                this.markDirty(this::saveLinkedBankAccount);
            }
            if (oldTeam != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), team, oldTeam));
            } else if (oldPlayer != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), team, oldPlayer));
            }
        }
        if (message.method_10545("AddAlly") && this.hasPermission(player, "addRemoveAllies") && (newAlly = PlayerReference.of(this.isClient, message.method_10558("AddAlly"))) != null && !PlayerReference.listContains(this.allies, newAlly.id)) {
            this.allies.add(newAlly);
            this.markDirty(this::saveAllies);
            if (player != null) {
                this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), true, newAlly));
            }
        }
        if (message.method_10545("RemoveAlly") && this.hasPermission(player, "addRemoveAllies") && (oldAlly = PlayerReference.of(this.isClient, message.method_10558("RemoveAlly"))) != null && PlayerReference.removeFromList(this.allies, oldAlly.id)) {
            this.markDirty(this::saveAllies);
            if (player != null) {
                this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), false, oldAlly));
            }
        }
        if (message.method_10545("ChangeAllyPermissions") && this.hasPermission(player, "editPermissions")) {
            String permission = message.method_10558("ChangeAllyPermissions");
            int newLevel = message.method_10550("NewLevel");
            this.setAllyPermissionLevel(player, permission, newLevel);
        }
        if (message.method_10545("ChangeName")) {
            this.setCustomName(player, message.method_10558("ChangeName"));
        }
        if (message.method_10545("MakeCreative")) {
            this.setCreative(player, message.method_10577("MakeCreative"));
        }
        if (message.method_10545("LinkToBankAccount")) {
            this.setLinkedToBank(player, message.method_10577("LinkToBankAccount"));
        }
        if (message.method_10545("Notifications") && this.hasPermission(player, "notifications") && this.notificationsEnabled != (enable2 = message.method_10577("Notifications"))) {
            this.notificationsEnabled = enable2;
            this.markDirty(this::saveNotificationData);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Notifications", String.valueOf(this.notificationsEnabled)));
            }
        }
        if (message.method_10545("NotificationsToChat") && this.hasPermission(player, "notifications") && this.notificationsToChat != (enable = message.method_10577("NotificationsToChat"))) {
            this.notificationsToChat = enable;
            this.markDirty(this::saveNotificationData);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "NotificationsToChat", String.valueOf(this.notificationsToChat)));
            }
        }
        if (message.method_10545("TeamNotificationLevel") && this.hasPermission(player, "notifications") && this.teamNotificationLevel != (level = message.method_10550("TeamNotificationLevel"))) {
            this.teamNotificationLevel = level;
            this.markDirty(this::saveNotificationData);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "TeamNotificationLevel", String.valueOf(this.teamNotificationLevel)));
            }
        }
        if (message.method_10545("TradeRuleEdit") && this.hasPermission(player, "editTradeRules")) {
            class_2960 type = new class_2960(message.method_10558("TradeRuleEdit"));
            int tradeIndex = message.method_10550("TradeIndex");
            class_2487 updateData = message.method_10562("TradeRuleData");
            if (tradeIndex >= 0) {
                try {
                    TradeRule rule;
                    TradeData trade = this.getTradeData().get(tradeIndex);
                    if (trade != null && (rule = TradeRule.getRule(type, trade.getRules())) != null) {
                        rule.receiveUpdateMessage(updateData);
                        this.markTradesDirty();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                TradeRule rule = TradeRule.getRule(type, this.rules);
                if (rule != null) {
                    rule.receiveUpdateMessage(updateData);
                    this.markDirty(this::saveRules);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final List<SettingsTab> getSettingsTabs() {
        ArrayList tabs = Lists.newArrayList((Object[])new SettingsTab[]{MainTab.INSTANCE, AllyTab.INSTANCE, PermissionsTab.INSTANCE, NotificationTab.INSTANCE});
        this.addSettingsTabs(tabs);
        tabs.add(OwnershipTab.INSTANCE);
        return tabs;
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract void addSettingsTabs(List<SettingsTab> var1);

    @Environment(value=EnvType.CLIENT)
    public final List<PermissionOption> getPermissionOptions() {
        ArrayList options = Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("openStorage"), BooleanPermission.of("changeName"), BooleanPermission.of("editTrades"), BooleanPermission.of("collectCoins"), BooleanPermission.of("storeCoins"), BooleanPermission.of("editTradeRules"), BooleanPermission.of("editSettings"), BooleanPermission.of("addRemoveAllies"), BooleanPermission.of("editPermissions"), BooleanPermission.of("viewLogs"), BooleanPermission.of("notifications"), BooleanPermission.of("bankLink"), BooleanPermission.of("breakTrader"), BooleanPermission.of("transferOwnership")});
        if (this.showOnTerminal()) {
            options.add(BooleanPermission.of("interactionLink"));
        }
        this.addPermissionOptions(options);
        return options;
    }

    @Environment(value=EnvType.CLIENT)
    protected abstract void addPermissionOptions(List<PermissionOption> var1);

    public final void pushLocalNotification(Notification notification) {
        if (this.isClient) {
            return;
        }
        this.logger.addNotification(notification);
        this.markDirty(this::saveLogger);
    }

    public final void pushNotification(Supplier<Notification> notificationSource) {
        if (this.isClient) {
            return;
        }
        this.pushLocalNotification(notificationSource.get());
        if (!this.notificationsEnabled) {
            return;
        }
        Team team = this.owner.getTeam();
        if (team != null) {
            ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
            if (this.teamNotificationLevel < 1) {
                sendTo.addAll(team.getMembers());
            }
            if (this.teamNotificationLevel < 2) {
                sendTo.addAll(team.getAdmins());
            }
            sendTo.add(team.getOwner());
            for (PlayerReference player : sendTo) {
                if (player == null || player.id == null) continue;
                NotificationSaveData.PushNotification(player.id, notificationSource.get(), this.notificationsToChat);
            }
        } else if (this.owner.hasPlayer()) {
            NotificationSaveData.PushNotification(this.owner.getPlayer().id, notificationSource.get(), this.notificationsToChat);
        }
    }

    public final TraderCategory getNotificationCategory() {
        return new TraderCategory((class_1935)(this.traderBlock != null ? this.traderBlock : ModItems.TRADING_CORE), this.getName(), this.id);
    }

    @Override
    @NotNull
    public final List<TraderData> getTraders() {
        return Lists.newArrayList((Object[])new TraderData[]{this});
    }

    @Override
    public final boolean isSingleTrader() {
        return true;
    }

    public static ExtendedScreenHandlerFactory getTraderMenuProvider(class_2338 traderSourcePosition) {
        return new TraderMenuProviderBlock(traderSourcePosition);
    }

    private record TraderMenuProvider(long traderID) implements ExtendedScreenHandlerFactory
    {
        public class_2561 method_5476() {
            return class_2561.method_43473();
        }

        public class_1703 createMenu(int windowID, class_1661 inv, class_1657 player) {
            return new TraderMenu(windowID, inv, this.traderID);
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.writeLong(this.traderID);
        }
    }

    private record TraderStorageMenuProvider(long traderID) implements ExtendedScreenHandlerFactory
    {
        public class_1703 createMenu(int windowID, class_1661 inventory, class_1657 player) {
            return new TraderStorageMenu(windowID, inventory, this.traderID);
        }

        public class_2561 method_5476() {
            return class_2561.method_43473();
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.writeLong(this.traderID);
        }
    }

    private record TraderMenuProviderBlock(class_2338 traderSourcePosition) implements ExtendedScreenHandlerFactory
    {
        public class_1703 createMenu(int windowID, class_1661 inventory, class_1657 player) {
            return new TraderMenu.TraderMenuBlockSource(windowID, inventory, this.traderSourcePosition);
        }

        public class_2561 method_5476() {
            return class_2561.method_43473();
        }

        public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
            buf.method_10807(this.traderSourcePosition);
        }
    }
}

