/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface ITraderSource {
    public static final ITraderSource CLIENT_TRADER_SOURCE = new NetworkTraderSource(true);
    public static final ITraderSource SERVER_TRADER_SOURCE = new NetworkTraderSource(false);
    public static final ITraderSource NULL = new NullTraderBlockSource();

    @NotNull
    public List<TraderData> getTraders();

    public boolean isSingleTrader();

    default public TraderData getSingleTrader() {
        return this.isSingleTrader() && this.getTraders().size() == 1 ? this.getTraders().get(0) : null;
    }

    public static ITraderSource getSafeSource(Supplier<ITraderSource> source) {
        return new SafeTraderSource(source);
    }

    public static ITraderSource UniversalTraderSource(boolean isClient) {
        return isClient ? CLIENT_TRADER_SOURCE : SERVER_TRADER_SOURCE;
    }

    public static class SafeTraderSource
    implements ITraderSource {
        private final Supplier<ITraderSource> traderSource;

        private SafeTraderSource(Supplier<ITraderSource> traderSource) {
            this.traderSource = traderSource;
        }

        private ITraderSource getSource() {
            ITraderSource source = this.traderSource.get();
            return source == null ? NULL : source;
        }

        @Override
        @NotNull
        public List<TraderData> getTraders() {
            return this.getSource().getTraders();
        }

        @Override
        public boolean isSingleTrader() {
            return this.getSource().isSingleTrader();
        }

        @Override
        public TraderData getSingleTrader() {
            return this.getSource().getSingleTrader();
        }
    }

    public static class NetworkTraderSource
    implements ITraderSource {
        private final boolean isClient;

        private NetworkTraderSource(boolean isClient) {
            this.isClient = isClient;
        }

        @Override
        @NotNull
        public List<TraderData> getTraders() {
            return TraderSaveData.GetAllTerminalTraders(this.isClient);
        }

        @Override
        public boolean isSingleTrader() {
            return false;
        }
    }

    public static class NullTraderBlockSource
    implements ITraderSource {
        private NullTraderBlockSource() {
        }

        @Override
        @NotNull
        public List<TraderData> getTraders() {
            return new ArrayList<TraderData>();
        }

        @Override
        public boolean isSingleTrader() {
            return false;
        }
    }
}

