/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traderinterface.handlers;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.Handler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurableSidedHandler
extends Handler {
    protected final DirectionalSettings inputSides;
    protected final DirectionalSettings outputSides;
    protected static final String UPDATE_INPUT_SIDE = "inputSide";
    protected static final String UPDATE_OUTPUT_SIDE = "outputSide";

    public DirectionalSettings getInputSides() {
        return this.inputSides;
    }

    public DirectionalSettings getOutputSides() {
        return this.outputSides;
    }

    protected ConfigurableSidedHandler() {
        this((ImmutableList<class_2350>)ImmutableList.of());
    }

    protected ConfigurableSidedHandler(ImmutableList<class_2350> ignoreSides) {
        this.inputSides = new DirectionalSettings(ignoreSides);
        this.outputSides = new DirectionalSettings(ignoreSides);
    }

    public void toggleInputSide(@NotNull class_2350 side) {
        this.inputSides.set(side, !this.inputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            class_2487 message = ConfigurableSidedHandler.initUpdateInfo(UPDATE_INPUT_SIDE);
            message.method_10569("side", side.method_10146());
            message.method_10556("newValue", this.inputSides.get(side));
            this.sendMessage(message);
        }
    }

    public static class_2487 initUpdateInfo(String updateType) {
        class_2487 compound = new class_2487();
        compound.method_10582("UpdateType", updateType);
        return compound;
    }

    public static boolean isUpdateType(class_2487 updateInfo, String updateType) {
        if (updateInfo.method_10573("UpdateType", 8)) {
            return updateInfo.method_10558("UpdateType").contentEquals(updateType);
        }
        return false;
    }

    public void toggleOutputSide(class_2350 side) {
        this.outputSides.set(side, !this.outputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            class_2487 message = ConfigurableSidedHandler.initUpdateInfo(UPDATE_OUTPUT_SIDE);
            message.method_10569("side", side.method_10146());
            message.method_10556("newValue", this.outputSides.get(side));
            this.sendMessage(message);
        }
    }

    @Override
    public void receiveMessage(class_2487 compound) {
        if (ConfigurableSidedHandler.isUpdateType(compound, UPDATE_INPUT_SIDE)) {
            class_2350 side = class_2350.method_10143((int)compound.method_10550("side"));
            if (compound.method_10577("newValue") != this.inputSides.get(side)) {
                this.toggleInputSide(side);
            }
        } else if (ConfigurableSidedHandler.isUpdateType(compound, UPDATE_OUTPUT_SIDE)) {
            class_2350 side = class_2350.method_10143((int)compound.method_10550("side"));
            if (compound.method_10577("newValue") != this.outputSides.get(side)) {
                this.toggleOutputSide(side);
            }
        }
    }

    @Override
    public final class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10566("InputSides", (class_2520)this.inputSides.save(new class_2487()));
        compound.method_10566("OutputSides", (class_2520)this.outputSides.save(new class_2487()));
        this.saveAdditional(compound);
        return compound;
    }

    protected void saveAdditional(class_2487 compound) {
    }

    @Override
    public void load(class_2487 compound) {
        if (compound.method_10573("InputSides", 10)) {
            this.inputSides.load(compound.method_10562("InputSides"));
        }
        if (compound.method_10573("OutputSides", 10)) {
            this.outputSides.load(compound.method_10562("OutputSides"));
        }
    }

    public static class DirectionalSettings {
        public final ImmutableList<class_2350> ignoreSides;
        private final Map<class_2350, Boolean> sideValues = new HashMap<class_2350, Boolean>();

        public DirectionalSettings() {
            this((ImmutableList<class_2350>)ImmutableList.of());
        }

        public DirectionalSettings(ImmutableList<class_2350> ignoreSides) {
            this.ignoreSides = ignoreSides;
        }

        public boolean allows(class_2350 side) {
            return !this.ignoreSides.contains((Object)side);
        }

        public boolean get(class_2350 side) {
            if (this.ignoreSides.contains((Object)side)) {
                return false;
            }
            return this.sideValues.getOrDefault(side, false);
        }

        public void set(class_2350 side, boolean value) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.sideValues.put(side, value);
        }

        public class_2487 save(class_2487 compound) {
            for (class_2350 side : class_2350.values()) {
                if (this.ignoreSides.contains((Object)side)) continue;
                compound.method_10556(side.toString(), this.get(side));
            }
            return compound;
        }

        public void load(class_2487 compound) {
            this.sideValues.clear();
            for (class_2350 side : class_2350.values()) {
                if (this.ignoreSides.contains((Object)side) || !compound.method_10545(side.toString())) continue;
                this.set(side, compound.method_10577(side.toString()));
            }
        }
    }
}

