/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader.item;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class ItemTradeNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "item_trade");
    TraderCategory traderData;
    ItemTradeData.ItemTradeType tradeType;
    List<ItemData> items;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    String customer;

    public ItemTradeNotification(ItemTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        this.traderData = traderData;
        this.tradeType = trade.getTradeType();
        this.items = new ArrayList<ItemData>();
        this.items.add(new ItemData(trade.getSellItem(0), trade.isPurchase() ? "" : trade.getCustomName(0)));
        this.items.add(new ItemData(trade.getSellItem(1), trade.isPurchase() ? "" : trade.getCustomName(1)));
        if (trade.isBarter()) {
            this.items.add(new ItemData(trade.getBarterItem(0), ""));
            this.items.add(new ItemData(trade.getBarterItem(1), ""));
        } else {
            this.cost = cost;
        }
        this.customer = customer.getName(false);
    }

    public ItemTradeNotification(class_2487 compound) {
        this.load(compound);
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public class_5250 getMessage() {
        class_2561 cost;
        class_5250 boughtText = class_2561.method_43471((String)("log.shoplog." + this.tradeType.name().toLowerCase()));
        class_2561 itemText = this.getItemNames(this.items.get(0), this.items.get(1));
        if (this.tradeType == ItemTradeData.ItemTradeType.BARTER) {
            cost = itemText;
            itemText = this.getItemNames(this.items.get(2), this.items.get(3));
        } else {
            cost = class_2561.method_43470((String)this.cost.getString("0"));
        }
        return class_2561.method_43469((String)"notifications.message.item_trade", (Object[])new Object[]{this.customer, boughtText, itemText, cost});
    }

    private class_2561 getItemNames(ItemData item1, ItemData item2) {
        if (item1.isEmpty && item2.isEmpty) {
            return class_2561.method_43470((String)"ERROR");
        }
        if (item2.isEmpty) {
            return item1.format();
        }
        if (item1.isEmpty) {
            return item2.format();
        }
        return item1.formatWith(item2);
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("TraderInfo", (class_2520)this.traderData.save());
        compound.method_10569("TradeType", this.tradeType.index);
        class_2499 itemList = new class_2499();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.method_10566("Items", (class_2520)itemList);
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            this.cost.save(compound, "Price");
        }
        compound.method_10582("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.traderData = new TraderCategory(compound.method_10562("TraderInfo"));
        this.tradeType = ItemTradeData.ItemTradeType.fromIndex(compound.method_10550("TradeType"));
        class_2499 itemList = compound.method_10554("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemData(itemList.method_10602(i)));
        }
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            this.cost.load(compound, "Price");
        }
        this.customer = compound.method_10558("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ItemTradeNotification) {
            ItemTradeNotification itn = (ItemTradeNotification)other;
            if (!itn.traderData.matches(this.traderData)) {
                return false;
            }
            if (itn.tradeType != this.tradeType) {
                return false;
            }
            if (itn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                ItemData i1 = this.items.get(i);
                ItemData i2 = itn.items.get(i);
                if (!i1.itemName.getString().equals(i2.itemName.getString())) {
                    return false;
                }
                if (i1.count == i2.count) continue;
                return false;
            }
            if (itn.cost.getRawValue() != this.cost.getRawValue()) {
                return false;
            }
            return itn.customer.equals(this.customer);
        }
        return false;
    }

    public static class ItemData {
        final boolean isEmpty;
        final class_2561 itemName;
        final int count;

        public ItemData(class_1799 item) {
            this(item, "");
        }

        public ItemData(class_1799 item, String customName) {
            this.isEmpty = item.method_7960();
            if (this.isEmpty) {
                this.itemName = class_2561.method_43473();
                this.count = 0;
                return;
            }
            this.itemName = customName.isEmpty() ? item.method_7964() : class_2561.method_43470((String)customName);
            this.count = item.method_7947();
        }

        public ItemData(class_2487 compound) {
            this.isEmpty = compound.method_10545("Empty");
            if (this.isEmpty) {
                this.itemName = class_2561.method_43473();
                this.count = 0;
                return;
            }
            this.itemName = class_2561.class_2562.method_10877((String)compound.method_10558("Name"));
            this.count = compound.method_10550("Count");
        }

        public class_2487 save() {
            class_2487 compound = new class_2487();
            if (this.isEmpty) {
                compound.method_10556("Empty", true);
                return compound;
            }
            compound.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.itemName));
            compound.method_10569("Count", this.count);
            return compound;
        }

        public class_2561 format() {
            return class_2561.method_43469((String)"log.shoplog.item.itemformat", (Object[])new Object[]{this.count, this.itemName});
        }

        public class_2561 formatWith(class_2561 other) {
            return class_2561.method_43469((String)"log.shoplog.and", (Object[])new Object[]{this.format(), other});
        }

        public class_2561 formatWith(ItemData other) {
            return class_2561.method_43469((String)"log.shoplog.and", (Object[])new Object[]{this.format(), other.format()});
        }

        public boolean matches(ItemData other) {
            return this.isEmpty == other.isEmpty && this.itemName.getString().equals(other.itemName.getString()) && this.count == other.count;
        }
    }
}

