/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class LowBalanceNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "bank_low_balance");
    private class_5250 accountName;
    private CoinValue value = new CoinValue(new CoinValue.CoinValuePair[0]);

    public LowBalanceNotification(class_5250 accountName, CoinValue value) {
        this.accountName = accountName;
        this.value = value;
    }

    public LowBalanceNotification(class_2487 compound) {
        this.load(compound);
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public class_5250 getMessage() {
        return class_2561.method_43469((String)"notifications.message.bank_low_balance", (Object[])new Object[]{this.value.getString()});
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.accountName));
        this.value.save(compound, "Amount");
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.accountName = class_2561.class_2562.method_10877((String)compound.method_10558("Name"));
        this.value.load(compound, "Amount");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof LowBalanceNotification) {
            LowBalanceNotification lbn = (LowBalanceNotification)other;
            if (!lbn.accountName.getString().equals(this.accountName.getString())) {
                return false;
            }
            return lbn.value.getRawValue() == this.value.getRawValue();
        }
        return false;
    }
}

