/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.bank;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class BankTransferNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "bank_transfer");
    PlayerReference player;
    CoinValue amount = new CoinValue(new CoinValue.CoinValuePair[0]);
    class_5250 accountName;
    class_5250 otherAccount;
    boolean wasReceived;

    public BankTransferNotification(class_2487 compound) {
        this.load(compound);
    }

    public BankTransferNotification(PlayerReference player, CoinValue amount, class_5250 accountName, class_5250 otherAccount, boolean wasReceived) {
        this.player = player;
        this.amount = amount;
        this.accountName = accountName;
        this.otherAccount = otherAccount;
        this.wasReceived = wasReceived;
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return new BankCategory(this.accountName);
    }

    @Override
    public class_5250 getMessage() {
        return class_2561.method_43469((String)"log.bank.transfer", (Object[])new Object[]{this.player.getName(true), this.amount.getComponent(), class_2561.method_43471((String)(this.wasReceived ? "log.bank.transfer.from" : "log.bank.transfer.to")), this.otherAccount});
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("Player", (class_2520)this.player.save());
        this.amount.save(compound, "Amount");
        compound.method_10582("Account", class_2561.class_2562.method_10867((class_2561)this.accountName));
        compound.method_10582("Other", class_2561.class_2562.method_10867((class_2561)this.otherAccount));
        compound.method_10556("Received", this.wasReceived);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.player = PlayerReference.load(compound.method_10562("Player"));
        this.amount.load(compound, "Amount");
        this.accountName = class_2561.class_2562.method_10877((String)compound.method_10558("Account"));
        this.otherAccount = class_2561.class_2562.method_10877((String)compound.method_10558("Other"));
        this.wasReceived = compound.method_10577("Received");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof BankTransferNotification) {
            BankTransferNotification n = (BankTransferNotification)other;
            return n.player.is(this.player) && n.amount.equals(this.amount) && n.accountName.equals((Object)this.accountName) && n.otherAccount.equals((Object)this.otherAccount) && n.wasReceived == this.wasReceived;
        }
        return false;
    }
}

