/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientNotifications;
import io.github.lightman314.lightmanscurrency.network.client.messages.notifications.SMessageClientNotification;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class NotificationSaveData
extends class_18 {
    private final Map<UUID, NotificationData> playerNotifications = new HashMap<UUID, NotificationData>();

    private NotificationSaveData() {
    }

    private NotificationSaveData(class_2487 compound) {
        class_2499 notificationData = compound.method_10554("PlayerNotifications", 10);
        for (int i = 0; i < notificationData.size(); ++i) {
            class_2487 tag = notificationData.method_10602(i);
            UUID id = tag.method_25926("Player");
            NotificationData data = NotificationData.loadFrom(tag);
            if (id == null) continue;
            this.playerNotifications.put(id, data);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 notificationData = new class_2499();
        this.playerNotifications.forEach((id, data) -> {
            class_2487 tag = data.save();
            tag.method_25927("Player", id);
            notificationData.add((Object)tag);
        });
        compound.method_10566("PlayerNotifications", (class_2520)notificationData);
        return compound;
    }

    private static NotificationSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (NotificationSaveData)level.method_17983().method_17924(NotificationSaveData::new, NotificationSaveData::new, "lightmanscurrency_notification_data");
        }
        return null;
    }

    @NotNull
    public static NotificationData GetNotifications(class_1657 player) {
        return player == null ? new NotificationData() : NotificationSaveData.GetNotifications(player.method_5667());
    }

    @NotNull
    public static NotificationData GetNotifications(UUID playerID) {
        if (playerID == null) {
            return new NotificationData();
        }
        NotificationSaveData nsd = NotificationSaveData.get();
        if (nsd != null) {
            if (!nsd.playerNotifications.containsKey(playerID)) {
                nsd.playerNotifications.put(playerID, new NotificationData());
                nsd.method_80();
            }
            return nsd.playerNotifications.get(playerID);
        }
        return new NotificationData();
    }

    public static void MarkNotificationsDirty(UUID playerID) {
        NotificationSaveData nsd = NotificationSaveData.get();
        if (nsd != null) {
            class_3222 player;
            nsd.method_80();
            MinecraftServer server = ServerHook.getServer();
            if (server != null && (player = server.method_3760().method_14602(playerID)) != null) {
                new SMessageUpdateClientNotifications(NotificationSaveData.GetNotifications(playerID)).sendTo(player);
            }
        }
    }

    public static boolean PushNotification(UUID playerID, Notification notification) {
        return NotificationSaveData.PushNotification(playerID, notification, true);
    }

    public static boolean PushNotification(UUID playerID, Notification notification, boolean pushToChat) {
        if (notification == null) {
            LightmansCurrency.LogError("Cannot push a null notification!");
            return false;
        }
        NotificationData data = NotificationSaveData.GetNotifications(playerID);
        if (data != null) {
            class_3222 player;
            MinecraftServer server;
            NotificationEvent.NotificationSent.Pre event = new NotificationEvent.NotificationSent.Pre(playerID, data, notification);
            if (!((NotificationEvent.NotificationPreSendCallback)NotificationEvent.PRE_SEND_EVENT.invoker()).allow(event)) {
                return false;
            }
            data.addNotification(event.getNotification());
            NotificationSaveData.MarkNotificationsDirty(playerID);
            ((NotificationEvent.NotificationSentCallback)NotificationEvent.NOTIFICATION_SENT_EVENT.invoker()).listen(new NotificationEvent.NotificationSent.Post(playerID, data, event.getNotification()));
            if (pushToChat && (server = ServerHook.getServer()) != null && (player = server.method_3760().method_14602(playerID)) != null) {
                new SMessageClientNotification(notification).sendTo(player);
            }
            return true;
        }
        return false;
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        NotificationData notifications = NotificationSaveData.GetNotifications((class_1657)player);
        new SMessageUpdateClientNotifications(notifications).sendTo(sender);
    }
}

