/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.wallet;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletSaveData;
import io.github.lightman314.lightmanscurrency.integration.trinketsapi.LCTrinketsAPI;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class WalletHandler {
    private boolean invalidated = false;
    private boolean wasInvalid = false;
    private class_1799 wallet = class_1799.field_8037;
    private class_1799 oldWallet = class_1799.field_8037;
    private boolean visible = true;
    private boolean wasVisible = true;
    private class_1657 latestPlayer = null;

    public WalletHandler updatePlayer(@NotNull class_1657 player) {
        this.latestPlayer = player;
        return this;
    }

    public class_1799 getWallet() {
        if (LCTrinketsAPI.isValid((class_1309)this.latestPlayer)) {
            return LCTrinketsAPI.getWallet((class_1309)this.latestPlayer);
        }
        return this.wallet;
    }

    public void setWallet(class_1799 walletStack) {
        if (LCTrinketsAPI.isValid((class_1309)this.latestPlayer) && LCTrinketsAPI.setWallet((class_1309)this.latestPlayer, walletStack)) {
            return;
        }
        this.invalidated = false;
        this.wallet = walletStack;
        if (!(walletStack.method_7909() instanceof WalletItem) && !walletStack.method_7960()) {
            LightmansCurrency.LogWarning("Equipped a non-wallet to the players wallet slot.");
        }
    }

    public boolean visible() {
        if (LCTrinketsAPI.isValid((class_1309)this.latestPlayer)) {
            return true;
        }
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isDirty() {
        return this.wasInvalid != this.invalidated || this.visible != this.wasVisible || !InventoryUtil.ItemMatches(this.wallet, this.oldWallet) || this.wallet.method_7947() != this.oldWallet.method_7947();
    }

    public void clean() {
        this.wasInvalid = this.invalidated;
        this.wasVisible = this.visible;
        this.oldWallet = this.wallet.method_7972();
    }

    public void tick() {
        if (this.invalidated || this.latestPlayer == null) {
            return;
        }
        if (!this.wallet.method_7960() && LCTrinketsAPI.isValid((class_1309)this.latestPlayer) && LCTrinketsAPI.setWallet((class_1309)this.latestPlayer, this.wallet)) {
            this.wallet = class_1799.field_8037;
            this.invalidated = true;
        }
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        if (this.invalidated) {
            compound.method_10556("Invalidated", true);
            return compound;
        }
        class_2487 walletTag = this.wallet.method_7953(new class_2487());
        compound.method_10566("Wallet", (class_2520)walletTag);
        compound.method_10556("Visible", this.visible);
        return compound;
    }

    public void load(class_2487 compound) {
        if (compound.method_10545("Invalidated") && compound.method_10577("Invalidated")) {
            this.invalidated = true;
            this.wallet = class_1799.field_8037;
            this.visible = false;
            return;
        }
        this.wallet = class_1799.method_7915((class_2487)compound.method_10562("Wallet"));
        this.visible = compound.method_10577("Visible");
        this.clean();
    }

    @NotNull
    public static WalletHandler getWallet(@NotNull class_1657 player) {
        return WalletSaveData.GetPlayerWallet(player);
    }

    public static void WalletSlotInteraction(class_1657 player, int clickedSlot, boolean heldShift, class_1799 heldItem) {
        boolean creative;
        LightmansCurrency.LogDebug("Wallet Slot interaction for slot " + clickedSlot + " (shift " + (heldShift ? "held" : "not held") + ") on the " + DebugUtil.getSideText((class_1297)player));
        class_1703 menu = player.field_7512;
        if (menu == null) {
            return;
        }
        boolean bl = creative = player.method_7337() && !player.method_37908().field_9236;
        if (!creative) {
            heldItem = menu.method_34255();
        }
        WalletHandler walletHandler = WalletHandler.getWallet(player);
        if (clickedSlot < 0) {
            class_1799 wallet = walletHandler.getWallet();
            if (heldShift) {
                if (wallet.method_7960()) {
                    return;
                }
                if (player.method_31548().method_7376() >= 0) {
                    if (!creative) {
                        player.method_31548().method_7394(wallet);
                    }
                    walletHandler.setWallet(class_1799.field_8037);
                }
            } else {
                if (wallet.method_7960() && heldItem.method_7960()) {
                    return;
                }
                if (WalletSlot.isValidWallet(heldItem) || heldItem.method_7960()) {
                    walletHandler.setWallet(heldItem);
                    if (!creative) {
                        menu.method_34254(wallet);
                    }
                }
            }
        } else if (heldShift) {
            class_1661 inventory = player.method_31548();
            if (clickedSlot >= inventory.method_5439()) {
                return;
            }
            class_1799 slotItem = inventory.method_5438(clickedSlot);
            if (WalletSlot.isValidWallet(slotItem) && walletHandler.getWallet().method_7960()) {
                if (!creative) {
                    if (slotItem.method_7947() > 1) {
                        inventory.method_5434(clickedSlot, 1);
                    } else {
                        inventory.method_5447(clickedSlot, class_1799.field_8037);
                    }
                }
                class_1799 newWallet = slotItem.method_7972();
                newWallet.method_7939(1);
                walletHandler.setWallet(newWallet);
            }
        }
    }
}

