/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachineEntryClientTab;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class SlotMachineEntryTab
extends TraderStorageTab {
    public SlotMachineEntryTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new SlotMachineEntryClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return true;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    public void AddEntry() {
        if (!this.menu.hasPermission("editTrades")) {
            return;
        }
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.addEntry();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("AddEntry", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void RemoveEntry(int entryIndex) {
        if (!this.menu.hasPermission("editTrades")) {
            return;
        }
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.removeEntry(entryIndex);
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("RemoveEntry", entryIndex);
                this.menu.sendMessage(message);
            }
        }
    }

    private void markEntriesDirty() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.markEntriesDirty();
        }
    }

    private SlotMachineEntry getEntry(int entryIndex) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            List<SlotMachineEntry> entries = trader.getAllEntries();
            if (entryIndex < 0 || entryIndex >= entries.size()) {
                return null;
            }
            return entries.get(entryIndex);
        }
        return null;
    }

    public void AddEntryItem(int entryIndex, class_1799 item) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            entry.TryAddItem(item);
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("EditEntry", entryIndex);
                message.method_10566("AddItem", (class_2520)item.method_7953(new class_2487()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void EditEntryItem(int entryIndex, int itemIndex, class_1799 item) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        if (item.method_7960()) {
            this.RemoveEntryItem(entryIndex, itemIndex);
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            if (itemIndex < 0 || itemIndex >= entry.items.size()) {
                return;
            }
            entry.items.set(itemIndex, item.method_7972());
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("EditEntry", entryIndex);
                message.method_10569("ItemIndex", itemIndex);
                message.method_10566("EditItem", (class_2520)item.method_7953(new class_2487()));
                this.menu.sendMessage(message);
            }
        }
    }

    public void RemoveEntryItem(int entryIndex, int itemIndex) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            if (itemIndex < 0 || itemIndex >= entry.items.size()) {
                return;
            }
            entry.items.remove(itemIndex);
            entry.validateItems();
            this.markEntriesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("EditEntry", entryIndex);
                message.method_10569("RemoveItem", itemIndex);
                this.menu.sendMessage(message);
            }
        }
    }

    public void ChangeEntryWeight(int entryIndex, int newWeight) {
        if (!this.menu.hasPermission("editTrades")) {
            Permissions.PermissionWarning(this.menu.player, "edit slot machine trade", "editTrades");
            return;
        }
        SlotMachineEntry entry = this.getEntry(entryIndex);
        if (entry != null) {
            entry.setWeight(newWeight);
            this.markEntriesDirty();
            LightmansCurrency.LogDebug("Changed entry[" + entryIndex + "]'s weight on the " + DebugUtil.getSideText((class_1297)this.menu.player) + "!");
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("EditEntry", entryIndex);
                message.method_10569("SetWeight", newWeight);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10545("AddEntry")) {
            this.AddEntry();
        }
        if (message.method_10545("RemoveEntry")) {
            this.RemoveEntry(message.method_10550("RemoveEntry"));
        }
        if (message.method_10545("EditEntry")) {
            int entryIndex = message.method_10550("EditEntry");
            if (message.method_10545("AddItem")) {
                this.AddEntryItem(entryIndex, class_1799.method_7915((class_2487)message.method_10562("AddItem")));
            } else if (message.method_10545("EditItem") && message.method_10545("ItemIndex")) {
                this.EditEntryItem(entryIndex, message.method_10550("ItemIndex"), class_1799.method_7915((class_2487)message.method_10562("EditItem")));
            } else if (message.method_10545("RemoveItem")) {
                this.RemoveEntryItem(entryIndex, message.method_10550("RemoveItem"));
            } else if (message.method_10545("SetWeight")) {
                this.ChangeEntryWeight(entryIndex, message.method_10550("SetWeight"));
            }
        }
    }
}

