/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate.PaygateTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import java.util.UUID;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_2487;

public class PaygateTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public PaygateTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new PaygateTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return this.menu.getTrader().hasPermission(player, "editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public PaygateTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (this.tradeIndex >= paygate.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.sendMessage(this.menu.createTabChangeMessage(0, null));
                return null;
            }
            return paygate.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setPrice(CoinValue price) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                price.save(message, "NewPrice");
                this.menu.sendMessage(message);
            }
        }
    }

    public void setTicket(UUID ticketID) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTicketID(ticketID);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("NewTicket", true);
                if (ticketID != null) {
                    message.method_25927("TicketID", ticketID);
                }
                this.menu.sendMessage(message);
            }
        }
    }

    public void setDuration(int duration) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDuration(duration);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("NewDuration", duration);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10545("TradeIndex")) {
            this.tradeIndex = message.method_10550("TradeIndex");
        } else if (message.method_10545("NewPrice")) {
            CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
            price.load(message, "NewPrice");
            this.setPrice(price);
        } else if (message.method_10545("NewTicket")) {
            UUID ticketID = null;
            if (message.method_10545("TicketID")) {
                ticketID = message.method_25926("TicketID");
            }
            this.setTicket(ticketID);
        } else if (message.method_10545("NewDuration")) {
            this.setDuration(message.method_10550("NewDuration"));
        }
    }
}

